/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.report;

import br.com.softplan.security.zap.api.exception.ZapClientException;
import br.com.softplan.security.zap.api.report.ZapReport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZapReportUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZapReportUtil.class);
    private static final String DEFAULT_REPORTS_PATH = System.getProperty("user.dir") + File.separator + "target" + File.separator + "zap-reports";

    public static void saveAllReports(ZapReport report) {
        ZapReportUtil.saveHtmlReport(report);
        ZapReportUtil.saveXmlReport(report);
        ZapReportUtil.saveHtmlSpiderResults(report);
        ZapReportUtil.saveXmlSpiderResults(report);
    }

    public static void saveAllReports(ZapReport report, String path) {
        ZapReportUtil.saveHtmlReport(report, path);
        ZapReportUtil.saveXmlReport(report, path);
        ZapReportUtil.saveHtmlSpiderResults(report, path);
        ZapReportUtil.saveXmlSpiderResults(report, path);
    }

    public static File saveHtmlReport(ZapReport report) {
        return ZapReportUtil.saveHtmlReport(report, DEFAULT_REPORTS_PATH);
    }

    public static File saveHtmlReport(ZapReport report, String path) {
        return ZapReportUtil.saveReport(report.getHtmlReport(), "zapReport.html", path);
    }

    public static File saveXmlReport(ZapReport report) {
        return ZapReportUtil.saveXmlReport(report, DEFAULT_REPORTS_PATH);
    }

    public static File saveXmlReport(ZapReport report, String path) {
        return ZapReportUtil.saveReport(report.getXmlReport(), "zapReport.xml", path);
    }

    public static File saveHtmlSpiderResults(ZapReport report) {
        return ZapReportUtil.saveHtmlSpiderResults(report, DEFAULT_REPORTS_PATH);
    }

    public static File saveHtmlSpiderResults(ZapReport report, String path) {
        return ZapReportUtil.saveReport(report.getHtmlSpiderResults(), "zapSpiderResults.html", path);
    }

    public static File saveXmlSpiderResults(ZapReport report) {
        return ZapReportUtil.saveXmlSpiderResults(report, DEFAULT_REPORTS_PATH);
    }

    public static File saveXmlSpiderResults(ZapReport report, String path) {
        return ZapReportUtil.saveReport(report.getXmlSpiderResults(), "zapSpiderResults.xml", path);
    }

    private static File saveReport(byte[] report, String name, String path) {
        ZapReportUtil.createReportsFolder(path);
        File reportFile = new File(path, name);
        try (FileOutputStream fos = new FileOutputStream(reportFile);){
            ((OutputStream)fos).write(report);
            LOGGER.info("{} saved to {}", (Object)name, (Object)path);
        }
        catch (IOException e) {
            String message = "Error saving reports.";
            LOGGER.error(message, (Throwable)e);
            throw new ZapClientException(message, e);
        }
        return reportFile;
    }

    private static void createReportsFolder(String path) {
        try {
            Files.createDirectories(Paths.get(path, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            String message = "Error creating reports folder.";
            LOGGER.error(message, (Throwable)e);
            throw new ZapClientException(message, e);
        }
    }

    private ZapReportUtil() {
    }
}

