/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.model;

import br.com.softplan.security.zap.api.authentication.AuthenticationInfoValidator;
import br.com.softplan.security.zap.api.model.AuthenticationType;
import br.com.softplan.security.zap.api.model.SeleniumDriver;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public final class AuthenticationInfo {
    private static final String DEFAULT_USERNAME_PARAMETER = "username";
    private static final String DEFAULT_PASSWORD_PARAMETER = "password";
    private static final String DEFAULT_LOGIN_REQUEST_DATA = "username={%username%}&password={%password%}";
    private static final SeleniumDriver DEFAULT_SELENIUM_DRIVER = SeleniumDriver.FIREFOX;
    private AuthenticationType type;
    private String loginUrl;
    private String username;
    private String password;
    private String extraPostData;
    private String loggedInRegex;
    private String loggedOutRegex;
    private String[] excludeFromScan;
    private String[] protectedPages;
    private String protectedPagesSeparatedByComma;
    private String loginRequestData;
    private String usernameParameter;
    private String passwordParameter;
    private String[] httpSessionTokens;
    private SeleniumDriver seleniumDriver;
    private String hostname;
    private String realm;
    private int port;

    public static Builder builder() {
        return new Builder();
    }

    public AuthenticationType getType() {
        return this.type;
    }

    public String getLoginUrl() {
        return this.loginUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getExtraPostData() {
        return this.extraPostData;
    }

    public String getFullLoginRequestData() {
        if (this.extraPostData != null) {
            return this.loginRequestData + "&" + this.extraPostData;
        }
        return this.loginRequestData;
    }

    public String getLoggedInRegex() {
        return this.loggedInRegex;
    }

    public String getLoggedOutRegex() {
        return this.loggedOutRegex;
    }

    public String[] getExcludeFromScan() {
        return this.excludeFromScan;
    }

    public String[] getProtectedPages() {
        return this.protectedPages;
    }

    public String getProtectedPagesSeparatedByComma() {
        return this.protectedPagesSeparatedByComma;
    }

    public String getLoginRequestData() {
        return this.loginRequestData;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public String[] getHttpSessionTokens() {
        return this.httpSessionTokens;
    }

    public SeleniumDriver getSeleniumDriver() {
        return this.seleniumDriver;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRealm() {
        return this.realm;
    }

    public int getPort() {
        return this.port;
    }

    public String getPortAsString() {
        return String.valueOf(this.port);
    }

    private AuthenticationInfo(Builder builder) {
        this.type = builder.type;
        this.loginUrl = builder.loginUrl;
        this.username = builder.username;
        this.password = builder.password;
        this.extraPostData = builder.extraPostData;
        this.loggedInRegex = builder.loggedInRegex;
        this.loggedOutRegex = builder.loggedOutRegex;
        this.excludeFromScan = builder.excludeFromScan;
        this.protectedPages = builder.protectedPages;
        this.protectedPagesSeparatedByComma = builder.protectedPagesSeparatedByComma;
        this.loginRequestData = builder.loginRequestData;
        this.usernameParameter = builder.usernameParameter;
        this.passwordParameter = builder.passwordParameter;
        this.httpSessionTokens = builder.httpSessionTokens;
        this.seleniumDriver = builder.seleniumDriver;
        this.hostname = builder.hostname;
        this.realm = builder.realm;
        this.port = builder.port;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("type", (Object)this.type.name()).append("loginUrl", (Object)this.loginUrl).append(DEFAULT_USERNAME_PARAMETER, (Object)this.username).append(DEFAULT_PASSWORD_PARAMETER, (Object)this.password).append("extraPostData", (Object)this.extraPostData).append("loggedInRegex", (Object)this.loggedInRegex).append("loggedOutRegex", (Object)this.loggedOutRegex).append("excludeFromScan", (Object[])this.excludeFromScan).append("protectedPages", (Object[])this.protectedPages).append("loginRequestData", (Object)this.loginRequestData).append("usernameParameter", (Object)this.usernameParameter).append("passwordParameter", (Object)this.passwordParameter).append("httpSessionTokens", (Object[])this.httpSessionTokens).append("seleniumDriver", (Object)this.seleniumDriver).append("hostname", (Object)this.hostname).append("realm", (Object)this.realm).append("port", this.port).toString();
    }

    static /* synthetic */ SeleniumDriver access$000() {
        return DEFAULT_SELENIUM_DRIVER;
    }

    public static class Builder {
        private AuthenticationType type;
        private String loginUrl;
        private String username;
        private String password;
        private String extraPostData;
        private String loggedInRegex;
        private String loggedOutRegex;
        private String[] excludeFromScan;
        private String[] protectedPages;
        private String protectedPagesSeparatedByComma;
        private String loginRequestData = "username={%username%}&password={%password%}";
        private String usernameParameter = "username";
        private String passwordParameter = "password";
        private String[] httpSessionTokens;
        private SeleniumDriver seleniumDriver = AuthenticationInfo.access$000();
        private String hostname;
        private String realm;
        private int port;

        public AuthenticationInfo buildHttpAuthenticationInfo(String username, String password, String hostname, String realm) {
            return this.type(AuthenticationType.HTTP).username(username).password(password).hostname(hostname).realm(realm).build();
        }

        public AuthenticationInfo buildFormAuthenticationInfo(String loginUrl, String username, String password) {
            return this.type(AuthenticationType.FORM).loginUrl(loginUrl).username(username).password(password).build();
        }

        public AuthenticationInfo buildCasAuthenticationInfo(String loginUrl, String username, String password, String ... protectedPages) {
            return this.type(AuthenticationType.CAS).loginUrl(loginUrl).username(username).password(password).protectedPages(protectedPages).build();
        }

        public AuthenticationInfo buildSeleniumAuthenticationInfo(String loginUrl, String username, String password) {
            return this.type(AuthenticationType.SELENIUM).loginUrl(loginUrl).username(username).password(password).build();
        }

        public Builder type(AuthenticationType type) {
            this.type = type;
            return this;
        }

        public Builder type(String type) {
            if (type != null) {
                this.type = AuthenticationType.valueOf(type.toUpperCase());
            }
            return this;
        }

        public Builder loginUrl(String loginUrl) {
            this.loginUrl = loginUrl;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder extraPostData(String extraPostData) {
            this.extraPostData = extraPostData;
            return this;
        }

        public Builder loggedInRegex(String loggedInRegex) {
            this.loggedInRegex = loggedInRegex;
            return this;
        }

        public Builder loggedOutRegex(String loggedOutRegex) {
            this.loggedOutRegex = loggedOutRegex;
            return this;
        }

        public Builder excludeFromScan(String ... excludeFromScan) {
            this.excludeFromScan = excludeFromScan;
            return this;
        }

        public Builder protectedPages(String ... protectedPages) {
            this.protectedPages = protectedPages;
            this.protectedPagesSeparatedByComma = protectedPages != null ? StringUtils.join((Object[])protectedPages, (String)",") : null;
            return this;
        }

        public Builder loginRequestData(String loginRequestData) {
            if (loginRequestData != null) {
                this.loginRequestData = loginRequestData;
            }
            return this;
        }

        public Builder loginRequestData() {
            this.loginRequestData = this.usernameParameter + "={%username%}&" + this.passwordParameter + "={%password%}";
            return this;
        }

        public Builder usernameParameter(String usernameParameter) {
            this.usernameParameter = usernameParameter;
            return this;
        }

        public Builder passwordParameter(String passwordParameter) {
            this.passwordParameter = passwordParameter;
            return this;
        }

        public Builder httpSessionTokens(String ... httpSessionTokens) {
            if (httpSessionTokens != null) {
                this.httpSessionTokens = httpSessionTokens;
            }
            return this;
        }

        public Builder seleniumDriver(SeleniumDriver seleniumDriver) {
            this.seleniumDriver = seleniumDriver;
            return this;
        }

        public Builder seleniumDriver(String seleniumDriver) {
            if (seleniumDriver != null) {
                this.seleniumDriver = SeleniumDriver.valueOf(seleniumDriver.toUpperCase());
            }
            return this;
        }

        public Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public AuthenticationInfo build() {
            AuthenticationInfo authenticationInfo = new AuthenticationInfo(this);
            AuthenticationInfoValidator.validate(authenticationInfo);
            return authenticationInfo;
        }
    }
}

