/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.authentication;

import br.com.softplan.security.zap.api.model.AuthenticationInfo;
import br.com.softplan.security.zap.commons.ZapInfo;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public final class WebDriverFactory {
    private static final int FIREFOX_MANUAL_PROXY_CONFIGURATION_OPTION = 1;

    public static WebDriver makeWebDriver(ZapInfo zapInfo, AuthenticationInfo authenticationInfo) {
        String host = zapInfo.getHost();
        int port = zapInfo.getPort();
        switch (authenticationInfo.getSeleniumDriver()) {
            case HTMLUNIT: {
                return WebDriverFactory.makeHtmlUnitDriver(host, port);
            }
            case FIREFOX: {
                return WebDriverFactory.makeFirefoxDriver(host, port);
            }
            case PHANTOMJS: {
                return WebDriverFactory.makePhantomJSDriver(host, port);
            }
        }
        return WebDriverFactory.makeFirefoxDriver(host, port);
    }

    public static HtmlUnitDriver makeHtmlUnitDriver(String host, int port) {
        HtmlUnitDriver driver = new HtmlUnitDriver();
        driver.setProxy(host, port);
        return driver;
    }

    public static FirefoxDriver makeFirefoxDriver(String host, int port) {
        FirefoxProfile profile = new FirefoxProfile();
        profile.setPreference("network.proxy.type", 1);
        profile.setPreference("network.proxy.share_proxy_settings", true);
        profile.setPreference("network.proxy.no_proxies_on", "");
        profile.setPreference("network.proxy.http", host);
        profile.setPreference("network.proxy.http_port", port);
        return new FirefoxDriver(profile);
    }

    private static WebDriver makePhantomJSDriver(String host, int port) {
        DesiredCapabilities capabilities = DesiredCapabilities.phantomjs();
        capabilities.setCapability("proxy", (Object)WebDriverFactory.createProxy(host, port));
        return new PhantomJSDriver((Capabilities)capabilities);
    }

    private static Proxy createProxy(String host, int port) {
        Proxy proxy = new Proxy();
        proxy.setHttpProxy(host + ":" + port);
        return proxy;
    }

    private WebDriverFactory() {
    }
}

