/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.authentication;

import br.com.softplan.security.zap.api.ZapHelper;
import br.com.softplan.security.zap.api.authentication.AbstractAuthenticationHandler;
import br.com.softplan.security.zap.api.authentication.AuthenticationScriptLoader;
import br.com.softplan.security.zap.api.exception.ZapClientException;
import br.com.softplan.security.zap.api.model.AuthenticationInfo;
import br.com.softplan.security.zap.commons.ZapInfo;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponse;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ClientApi;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ClientApiException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasAuthenticationHandler.class);
    public static final String SCRIPT_NAME = "cas-auth";
    private static final String SCRIPT_DESCRIPTION = "CAS authentication script";
    private static final String SCRIPT_AUTHENTICATION_TYPE = "scriptBasedAuthentication";
    private static final String SCRIPT_NAME_PARAM = "scriptName";
    private static final String LOGIN_PAGE_PARAM = "loginUrl";
    private static final String PROTECTED_PAGES_PARAM = "protectedPages";
    private static final String EXTRA_POST_DATA_PARAM = "extraPostData";
    private AuthenticationScriptLoader scriptLoader;

    protected CasAuthenticationHandler(ClientApi api, ZapInfo zapInfo, AuthenticationInfo authenticationInfo) {
        super(api, zapInfo, authenticationInfo);
        this.scriptLoader = new AuthenticationScriptLoader(api, zapInfo, SCRIPT_NAME, SCRIPT_DESCRIPTION);
    }

    @Override
    protected void setupAuthentication(String targetUrl) {
        this.scriptLoader.loadScript();
        this.setScriptAuthenticationMethod();
        this.createAndEnableUser();
        this.setupUserCredentials();
        this.enableForcedUserMode();
    }

    private void setScriptAuthenticationMethod() {
        try {
            String encodedScriptName = URLEncoder.encode(SCRIPT_NAME, UTF_8);
            String encodedLoginUrl = URLEncoder.encode(this.getAuthenticationInfo().getLoginUrl(), UTF_8);
            String encodedProtectedPages = URLEncoder.encode(this.getAuthenticationInfo().getProtectedPagesSeparatedByComma(), UTF_8);
            String authParams = "scriptName=" + encodedScriptName + "&" + LOGIN_PAGE_PARAM + "=" + encodedLoginUrl + "&" + PROTECTED_PAGES_PARAM + "=" + encodedProtectedPages;
            String extraPostData = this.getAuthenticationInfo().getExtraPostData();
            if (extraPostData != null) {
                String encodedExtraPostData = URLEncoder.encode(extraPostData, UTF_8);
                authParams = authParams + "&extraPostData=" + encodedExtraPostData;
            }
            LOGGER.debug("Setting script authentication method with params: {}", (Object)authParams);
            ApiResponse response = this.getApi().authentication.setAuthenticationMethod(this.getApiKey(), "1", SCRIPT_AUTHENTICATION_TYPE, authParams);
            ZapHelper.validateResponse(response, "Set script authentication method");
        }
        catch (ClientApiException | UnsupportedEncodingException e) {
            LOGGER.error("Error setting up script authentication method.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }
}

