/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api;

import br.com.softplan.security.zap.api.exception.ZapClientException;
import br.com.softplan.security.zap.api.model.AnalysisInfo;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponse;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ApiResponseElement;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ClientApi;
import br.com.softplan.security.zap.zaproxy.clientapi.core.ClientApiException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZapHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZapHelper.class);
    private static final String ZAP_SUCCESS_RESPONSE = "OK";
    private static final String ZAP_DEFAULT_CONTEXT_NAME = "Default Context";

    public static String extractResponse(ApiResponse response) {
        return ((ApiResponseElement)response).getValue();
    }

    public static void validateResponse(ApiResponse response, String operationDescription) {
        String responseValue = ZapHelper.extractResponse(response);
        if (!responseValue.equals(ZAP_SUCCESS_RESPONSE)) {
            String message = "ZAP API did not respond 'OK' during the following operation: " + operationDescription + ". Actual response: " + responseValue;
            LOGGER.error(message);
            throw new ZapClientException(message);
        }
    }

    public static void includeInContext(ClientApi api, String apiKey, AnalysisInfo analysisInfo) {
        Object[] context = analysisInfo.getContext();
        LOGGER.debug("Including target '{}' in context.", (Object)Arrays.toString(context));
        try {
            for (Object contextUrl : context) {
                if (ZapHelper.isContextUrlRelative((String)contextUrl)) {
                    contextUrl = ZapHelper.resolveContextUrl((String)contextUrl, analysisInfo);
                }
                ApiResponse response = api.context.includeInContext(apiKey, ZAP_DEFAULT_CONTEXT_NAME, "\\Q" + (String)contextUrl + "\\E.*");
                ZapHelper.validateResponse(response, "Include target in context.");
            }
        }
        catch (ClientApiException e) {
            LOGGER.error("Error including target in context.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }

    private static boolean isContextUrlRelative(String contextUrl) {
        return !contextUrl.startsWith("http");
    }

    private static String resolveContextUrl(String contextUrl, AnalysisInfo analysisInfo) {
        String activeScanStartingPointUrl = analysisInfo.getActiveScanStartingPointUrl();
        if (activeScanStartingPointUrl.endsWith("/")) {
            activeScanStartingPointUrl = activeScanStartingPointUrl.substring(0, activeScanStartingPointUrl.length() - 1);
        }
        if (contextUrl.startsWith("/")) {
            contextUrl = contextUrl.substring(1);
        }
        return activeScanStartingPointUrl + "/" + contextUrl;
    }

    public static void setTechnologiesInContext(ClientApi api, String apiKey, AnalysisInfo analysisInfo) {
        String technologies = analysisInfo.getTechnologiesSeparatedByComma();
        if (technologies == null) {
            return;
        }
        LOGGER.debug("Setting technologies in context: {}.", (Object)technologies);
        try {
            ApiResponse responseFromExcludingTechnologies = api.context.excludeAllContextTechnologies(apiKey, ZAP_DEFAULT_CONTEXT_NAME);
            ZapHelper.validateResponse(responseFromExcludingTechnologies, "Exclude all context technologies.");
            ApiResponse responseFromIncludingTechnologies = api.context.includeContextTechnologies(apiKey, ZAP_DEFAULT_CONTEXT_NAME, technologies);
            ZapHelper.validateResponse(responseFromIncludingTechnologies, "Exclude all context technologies.");
        }
        catch (ClientApiException e) {
            LOGGER.error("Error setting technologies in context.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }

    private ZapHelper() {
    }
}

