/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.bfgex.interpreter;

import br.com.six2six.bfgex.RandomGen;
import br.com.six2six.bfgex.interpreter.RandomLiteral;
import java.util.regex.Pattern;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberRange;

public class Quantifier {
    private static Pattern QUANTIFIERS = Pattern.compile("[+?*]");
    private NumberRange numberRange;
    private Integer number;
    private String quantity;

    public Quantifier(NumberRange numberRange) {
        this.numberRange = numberRange;
    }

    public Quantifier(Integer number) {
        this.number = number;
    }

    public Quantifier(String quantity) {
        if (!QUANTIFIERS.matcher(quantity).find()) {
            throw new IllegalArgumentException("invalid quantifier");
        }
        this.quantity = quantity;
    }

    public String genValue(Object value) {
        return (String)ObjectUtils.defaultIfNull((Object)this.verifyReluctant(value), (Object)ObjectUtils.defaultIfNull((Object)this.verifyGreedy(value), (Object)this.verifyNumberRange(value)));
    }

    private String verifyReluctant(Object value) {
        return this.quantity != null && this.quantity.equals("?") ? RandomGen.pickOne("", this.pickValue(value, 1)) : null;
    }

    private String verifyGreedy(Object value) {
        return this.quantity != null && this.quantity.matches("[+*]") ? this.pickValue(value, null) : null;
    }

    private String verifyNumberRange(Object value) {
        Integer numberValue = null;
        if (this.numberRange != null) {
            numberValue = RandomGen.pickRange(this.numberRange).intValue();
        } else if (this.number != null) {
            numberValue = this.number;
        }
        return numberValue != null ? this.pickValue(value, numberValue) : null;
    }

    private String pickValue(Object value, Integer length) {
        String result = null;
        if (value instanceof String) {
            result = StringUtils.repeat((String)((String)value), (int)length);
        } else if (value instanceof String[]) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                sb.append(RandomGen.pickArray((String[])value));
            }
            result = sb.toString();
        } else {
            switch ((RandomLiteral)((Object)value)) {
                case DIGIT: {
                    result = RandomGen.pickDigits(length);
                    break;
                }
                case SPACE: {
                    result = RandomGen.pickWhiteSpaces(length);
                    break;
                }
                case WORD: {
                    result = RandomGen.word(length);
                }
            }
        }
        return result;
    }

    public String toString() {
        return ObjectUtils.defaultIfNull((Object)this.quantity, (Object)ObjectUtils.defaultIfNull((Object)this.number, (Object)this.numberRange)).toString();
    }
}

