/*
 * Decompiled with CFR 0.152.
 */
package br.com.six2six.bfgex.interpreter;

import br.com.six2six.bfgex.interpreter.Exp;
import br.com.six2six.bfgex.interpreter.Quantifier;
import br.com.six2six.bfgex.interpreter.RandomLiteral;
import br.com.six2six.bfgex.interpreter.Sexp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberRange;

public class Parser {
    private static Pattern POSSESSIVE_QUANTIFIERS = Pattern.compile("^(.*)(\\*|\\*\\?|\\+|\\+\\?|\\?)$");
    private static Pattern RANGE_QUANTIFIERS = Pattern.compile("^(.*)\\{(\\d+)\\,(\\d+)\\}$");
    private static Pattern NUMBER_QUANTIFIER = Pattern.compile("^(.*)\\{(\\d+)\\}$");
    private static Pattern BALANCED_UNION = Pattern.compile("^\\((.*)\\)\\((.*)\\)$");
    private static Pattern BALANCED_INTERSECTION = Pattern.compile("^(\\(.*\\))\\|(\\(.*\\))$");
    private static Pattern IMPLIED_INTERSECTION = Pattern.compile("^(.*)\\|(.*)$");
    private static Pattern UNBALANCED_INTERSECTION = Pattern.compile("^(.*)\\|\\((\\(.*\\))\\)$");
    private static Pattern UNBALANCED_UNION = Pattern.compile("^(.+)(\\(.*\\))$");
    private static Pattern EXPLICIT_GROUP = Pattern.compile("^\\((.*)\\)$");
    private static Pattern IMPLIED_GROUP = Pattern.compile("^([^()]*)(\\(.*\\))$");
    private static Pattern CHARACTER_CLASS = Pattern.compile("^(.*)\\[(.*)\\]$");
    private static Pattern CUSTOM_RANDOM = Pattern.compile("^(.*)\\[\\:(.*)\\:\\]$");
    private static Pattern RESERVED_RANDOM = Pattern.compile("^(.*)\\\\([wsdc])$");
    private static Pattern LITERAL_PATTERN = Pattern.compile("^(.*)\\\\(.)$");
    private static Pattern SPACE = Pattern.compile("(.*)(.|\\s)$");

    public static Sexp parse(String pattern) {
        Pattern.compile(pattern);
        Matcher matcher = POSSESSIVE_QUANTIFIERS.matcher(pattern);
        if (matcher.find()) {
            Quantifier quantifier = StringUtils.isNumeric((String)matcher.group(2)) ? new Quantifier(Integer.valueOf(matcher.group(2))) : new Quantifier(matcher.group(2));
            return Parser.parseQuantified(matcher.group(1), quantifier);
        }
        matcher = RANGE_QUANTIFIERS.matcher(pattern);
        if (matcher.find()) {
            Integer quantifierStart = Integer.valueOf(matcher.group(2));
            Integer quantifierEnd = Integer.valueOf(matcher.group(3));
            return Parser.parseQuantified(matcher.group(1), new Quantifier(new NumberRange((Number)quantifierStart, (Number)quantifierEnd)));
        }
        matcher = NUMBER_QUANTIFIER.matcher(pattern);
        if (matcher.find()) {
            return Parser.parseQuantified(matcher.group(1), new Quantifier(Integer.valueOf(matcher.group(2))));
        }
        matcher = BALANCED_UNION.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), Parser.parse(matcher.group(2)));
        }
        matcher = BALANCED_INTERSECTION.matcher(pattern);
        if (matcher.find()) {
            return Parser.intersection(Parser.parse(matcher.group(1)), Parser.parse(matcher.group(2)));
        }
        matcher = IMPLIED_INTERSECTION.matcher(pattern);
        if (matcher.find()) {
            return Parser.intersection(Parser.parse(matcher.group(1)), Parser.parse(matcher.group(2)));
        }
        matcher = UNBALANCED_INTERSECTION.matcher(pattern);
        if (matcher.find()) {
            return Parser.intersection(Parser.parse(matcher.group(1)), Parser.parse(matcher.group(2)));
        }
        matcher = UNBALANCED_UNION.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), Parser.parse(matcher.group(2)));
        }
        matcher = EXPLICIT_GROUP.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), new Sexp[0]);
        }
        matcher = IMPLIED_GROUP.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), new Sexp[0]);
        }
        matcher = CHARACTER_CLASS.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), Parser.parseCharacterClass(matcher.group(2)));
        }
        matcher = CUSTOM_RANDOM.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), Parser.random(matcher.group(2)));
        }
        matcher = RESERVED_RANDOM.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), Parser.random(matcher.group(2)));
        }
        matcher = LITERAL_PATTERN.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), Parser.literal(matcher.group(2)));
        }
        matcher = SPACE.matcher(pattern);
        if (matcher.find()) {
            return Parser.union(Parser.parse(matcher.group(1)), Parser.literal(matcher.group(2)));
        }
        return null;
    }

    private static Sexp parseQuantified(String source, Quantifier quantifier) {
        Sexp quantifiedSexp = null;
        quantifiedSexp = source.matches("^[^()]*$") ? Parser.quantifyRhs(Parser.parse(source), quantifier) : (source.matches("^(\\(.*\\))$") ? Parser.quantify(Parser.parse(source), quantifier) : (source.matches("^(.*\\))$") || source.matches("^(.*[^)]+)$") ? Parser.quantifyRhs(Parser.parse(source), quantifier) : Parser.quantify(Parser.parse(source), quantifier)));
        return quantifiedSexp;
    }

    private static Sexp quantifyRhs(Sexp sexp, Quantifier quantifier) {
        Sexp quantifierSexp = null;
        quantifierSexp = sexp.first() != null && sexp.first().equals((Object)Exp.UNION) ? sexp.add(Parser.quantify((Sexp)sexp.removeLast(), quantifier)) : Parser.quantify(sexp, quantifier);
        return quantifierSexp;
    }

    private static Sexp quantify(Sexp sexp, Quantifier quantifier) {
        return new Sexp(Exp.QUANTIFY).add(sexp).add(quantifier);
    }

    private static Sexp union(Sexp lhs, Sexp ... rhs) {
        if (lhs == null) {
            return Parser.union(rhs[0], (Sexp[])ArrayUtils.remove((Object[])rhs, (int)0));
        }
        if (ArrayUtils.isEmpty((Object[])rhs)) {
            return lhs;
        }
        if (lhs.first() != null && lhs.first().equals((Object)Exp.UNION)) {
            for (Sexp sexp : rhs) {
                lhs.add(sexp);
            }
            return lhs;
        }
        return new Sexp(Exp.UNION).add(lhs).addAll(rhs);
    }

    private static Sexp intersection(Sexp lhs, Sexp rhs) {
        Sexp intersectionSexp = new Sexp(Exp.INTERSECTION).add(lhs);
        if (rhs.first().equals((Object)Exp.INTERSECTION)) {
            intersectionSexp.addAll(ArrayUtils.remove((Object[])rhs.getValues().toArray(), (int)0));
        } else {
            intersectionSexp.add(rhs);
        }
        return intersectionSexp;
    }

    private static Sexp parseCharacterClass(String source) {
        return Parser.parseCharacterClass(source, new Sexp(Exp.CHARCLASS));
    }

    private static Sexp parseCharacterClass(String pattern, Sexp sexp) {
        Matcher matcher = Pattern.compile("(.*)(.\\-.)(.*)").matcher(pattern);
        if (matcher.matches()) {
            String[] range = matcher.group(2).split("-");
            Parser.parseCharacterClass(matcher.group(1), sexp);
            sexp.add(new Sexp(Exp.RANGE).add(Parser.literal(range[0])).add(Parser.literal(range[1])));
            Parser.parseCharacterClass(matcher.group(3), sexp);
        } else if (!pattern.isEmpty()) {
            for (String token : pattern.split("(?!^)")) {
                sexp.add(Parser.literal(token));
            }
        }
        return sexp;
    }

    private static Sexp literal(String word) {
        return new Sexp(Exp.LITERAL).add(word);
    }

    private static Sexp random(String value) {
        return new Sexp(Exp.RANDOM).add((Object)RandomLiteral.get(value));
    }
}

