/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.rio.dhcp;

import br.com.objectos.rio.dhcp.AbstractServer;
import br.com.objectos.rio.dhcp.AckMessage;
import br.com.objectos.rio.dhcp.DhcpDatagram;
import br.com.objectos.rio.dhcp.DhcpServerBuilder;
import br.com.objectos.rio.dhcp.DhcpServerConfiguration;
import br.com.objectos.rio.dhcp.DhcpServerListener;
import br.com.objectos.rio.dhcp.DiscoveryMessage;
import br.com.objectos.rio.dhcp.MessageType;
import br.com.objectos.rio.dhcp.OfferMessage;
import br.com.objectos.rio.dhcp.RequestMessage;
import br.com.objectos.rio.dhcp.ServerConfiguredAdapter;
import br.com.objectos.rio.net.HardwareAddress;
import br.com.objectos.rio.net.IpAddress;
import br.com.objectos.rio.net.NetInteger;
import br.com.objectos.rio.udp.Packet;
import br.com.objectos.rio.udp.UdpException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public abstract class DhcpServer
extends AbstractServer {
    private static final Logger logger = Logger.getLogger(DhcpServer.class.getName());
    private final DhcpServerConfiguration configuration;
    private final List<DhcpServerListener> listenerList;

    DhcpServer(DhcpServerBuilder builder) {
        this.configuration = builder.configuration();
        this.listenerList = builder.listenerList();
    }

    public DhcpServerConfiguration configuration() {
        return this.configuration;
    }

    public void onPacket(Packet packet) throws UdpException {
        if (!packet.fromPort(this.clientPort())) {
            return;
        }
        DhcpDatagram datagram = (DhcpDatagram)packet.decode(DhcpDatagram::read);
        logger.info("Received: " + datagram);
        MessageType.clientMessageTypes().stream().filter(type -> datagram.matches(type)).findFirst().map(type -> type.readClientMessage(datagram)).filter(in -> in.matches((AbstractServer)this)).map(in -> in.nextMessage((AbstractServer)this)).ifPresent(out -> {
            try {
                out.broadcastOrSend((AbstractServer)this);
            }
            catch (UdpException e) {
                e.printStackTrace();
            }
        });
    }

    public DhcpServer start() throws UdpException {
        return (DhcpServer)super.start();
    }

    int clientPort() {
        return this.port() + 1;
    }

    ServerConfiguredAdapter configuredAdapter(HardwareAddress chaddr) {
        return this.configuration.configuredAdapter(chaddr);
    }

    final IpAddress ipAddress() {
        return this.configuration.ipAddress();
    }

    boolean matches(IpAddress ipAddress) {
        return Objects.equals(this.ipAddress(), ipAddress);
    }

    void onAckSent(AckMessage message) {
        for (DhcpServerListener listener : this.listenerList) {
            listener.onAckSent(message);
        }
    }

    void onDiscovery(DiscoveryMessage message) {
        for (DhcpServerListener listener : this.listenerList) {
            listener.onDiscoveryReceived(message);
        }
    }

    void onOfferSent(OfferMessage message) {
        for (DhcpServerListener listener : this.listenerList) {
            listener.onOfferSent(message);
        }
    }

    void onRequest(RequestMessage message) {
        for (DhcpServerListener listener : this.listenerList) {
            listener.onRequestReceived(message);
        }
    }

    final int port() {
        return this.configuration.port();
    }

    IpAddress.Array domainNameServer(HardwareAddress chaddr) {
        return IpAddress.Array.of((IpAddress[])new IpAddress[]{IpAddress.of((int)8, (int)8, (int)8, (int)8), IpAddress.of((int)8, (int)8, (int)4, (int)4)});
    }

    IpAddress ipAddress(HardwareAddress chaddr) {
        return IpAddress.of((int)192, (int)168, (int)0, (int)102);
    }

    NetInteger leaseTime(HardwareAddress chaddr) {
        return NetInteger.of((int)86400);
    }

    IpAddress.Array router(HardwareAddress chaddr) {
        return IpAddress.Array.of((IpAddress[])new IpAddress[]{this.ipAddress()});
    }

    IpAddress subnetMask(HardwareAddress chaddr) {
        return IpAddress.of((int)255, (int)255, (int)255, (int)0);
    }
}

