/*
 * Copyright 2016 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.dhcp;

import java.util.List;
import java.util.Map;

import br.com.objectos.core.util.ImmutableList;
import br.com.objectos.rio.net.HardwareAddress;
import br.com.objectos.rio.net.IpAddress;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class DhcpServerConfiguration {

  private final IpAddress ipAddress;
  private final int port;

  private final Map<HardwareAddress, ServerConfiguredAdapter> configuredAdapterMap;

  DhcpServerConfiguration(IpAddress ipAddress,
                          int port,
                          Map<HardwareAddress, ServerConfiguredAdapter> configuredAdapterMap) {
    this.ipAddress = ipAddress;
    this.port = port;
    this.configuredAdapterMap = configuredAdapterMap;
  }

  public List<ConfiguredAdapter> configuredAdapterList() {
    return ImmutableList.copyOf(configuredAdapterMap.values());
  }

  public DhcpServerConfigurationEdit edit() {
    return new DhcpServerConfigurationEdit(this);
  }

  void addHost(Host host) {
    ServerConfiguredAdapter configuredAdapter = host.toConfiguredAdapter(ipAddress);
    configuredAdapterMap.put(configuredAdapter.hardwareAddress(), configuredAdapter);
  }

  void clear() {
    configuredAdapterMap.clear();
  }

  ServerConfiguredAdapter configuredAdapter(HardwareAddress chaddr) {
    return configuredAdapterMap.get(chaddr);
  }

  IpAddress ipAddress() {
    return ipAddress;
  }

  void lock() {
  }

  int port() {
    return port;
  }

}