/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.iro;

import static br.com.objectos.rio.RioVersion.VERSION;
import br.com.objectos.rio.HttpServer;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
@Parameters
class DisklessEtoPrepareOptions {

  String version = VERSION.get();

  @Parameter(names = "--all")
  boolean all;

  @Parameter(names = "--stage")
  boolean stage;

  @Parameter(names = { "--objectos", "-o" })
  boolean objectos = false;

  @Parameter(names = { "--initramfs", "-i" })
  boolean initramfs = false;

  @Parameter(names = { "--ekernel", "-k" })
  boolean ekernel = false;

  @Parameter(names = { "--eworld", "-w" })
  boolean eworld = false;

  @Parameter(names = { "--grub", "-g" })
  boolean grub = false;

  @Parameter(names = { "--rio", "-r" })
  boolean rio = false;

  @Parameter(names = "--server")
  String server = "rio.objectos.com.br";

  public HttpServer fileServer() {
    String base = String.format("%s/iro/eto/%s", server, version);
    return HttpServer.at(base);
  }

  public HttpServer distfilesServer() {
    String base = String.format("%s/gentoo/distfiles", server);
    return HttpServer.at(base);
  }

  public boolean all() {
    if (all) {
      stage = true;
      objectos = true;
      ekernel = true;
      eworld = true;
      grub = true;
      rio = true;
    }

    return all;
  }

}