/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.rio.iro;

import static br.com.objectos.rio.RioVersion.VERSION;

import java.io.File;

import br.com.objectos.way.base.io.Directory;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
@Parameters
class DisklessEtoMirrorOptions {

  String version = VERSION.get();

  @Parameter(names = { "--stage3", "-3" })
  public boolean stage3 = false;

  @Parameter(names = { "--stage3-upload", "-3u" })
  public boolean stage3Upload = false;

  @Parameter(names = "--server")
  String server = "rio.objectos.com.br";

  public String remotePath() {
    return "/var/www/localhost/htdocs/iro/eto/" + version;
  }

  public File stage3File(IroDirs dirs) {
    Directory etoVar = dirs.etoVar();
    String name = String.format("iro-eto-%s.tar.gz", version);
    return etoVar.fileAt(name);
  }

}