/*
 * Copyright (C) 2011-2022 Objectos Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package br.com.objectos.testing.fs;

import br.com.objectos.collections.list.ImmutableList;
import br.com.objectos.collections.list.Lists;
import br.com.objectos.collections.list.MutableList;
import br.com.objectos.fs.Directory;
import br.com.objectos.fs.DirectoryContentsVisitor;
import br.com.objectos.fs.RegularFile;
import java.io.File;
import java.io.IOException;

final class DirectoryListBuilder implements DirectoryContentsVisitor {

  private final MutableList<String> leafs = MutableList.create();

  private final DirectoryListMode mode;

  private String prefix = "";

  DirectoryListBuilder(DirectoryListMode mode) {
    this.mode = mode;
  }

  public final ImmutableList<String> build(Directory directory) throws IOException {
    directory.visitContents(this);

    leafs.sort(Lists.naturalOrder());

    return leafs.toImmutableList();
  }

  @Override
  public final void visitDirectory(Directory directory) throws IOException {
    String previousPrefix;
    previousPrefix = prefix;

    String directoryName;
    directoryName = directory.getName();

    prefix = prefix + directoryName;

    prefix = prefix + File.separatorChar;

    switch (mode) {
      case FILES:
        // noop
        break;
      default:
        leafs.add(prefix);
        break;

    }

    directory.visitContents(this);

    prefix = previousPrefix;
  }

  @Override
  public final void visitRegularFile(RegularFile file) throws IOException {
    String leaf;
    leaf = prefix + file.getName();

    leafs.add(leaf);
  }

}