/*
 * Decompiled with CFR 0.152.
 */
package br.com.objectos.aws.rds.maven.plugin;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.rds.AmazonRDSClient;
import com.amazonaws.services.rds.model.CreateDBSnapshotRequest;
import com.amazonaws.services.rds.model.DBSnapshot;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="create-snapshot")
public class CreateSnapshotMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String accessKey;
    @Parameter(required=true)
    private String secretKey;
    @Parameter(required=true)
    private String dBInstanceIdentifier;
    @Parameter(required=true)
    private String dBSnapshotIdentifier;
    @Parameter
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            this.execute0();
        }
    }

    void info(String template, Object ... args) {
        String message = String.format(template, args);
        this.logger().info((CharSequence)message);
    }

    private DBSnapshot describeSnapshot(AmazonRDSClient client) {
        DBSnapshot snapshot = null;
        DescribeDBSnapshotsRequest describeDBSnapshotsRequest = new DescribeDBSnapshotsRequest().withDBSnapshotIdentifier(this.dBSnapshotIdentifier);
        DescribeDBSnapshotsResult describeDBSnapshots = client.describeDBSnapshots(describeDBSnapshotsRequest);
        List list = describeDBSnapshots.getDBSnapshots();
        if (!list.isEmpty()) {
            snapshot = (DBSnapshot)list.get(0);
        }
        return snapshot;
    }

    private void execute0() throws MojoExecutionException {
        BasicAWSCredentials credentials = new BasicAWSCredentials(this.accessKey, this.secretKey);
        AmazonRDSClient client = new AmazonRDSClient((AWSCredentials)credentials);
        CreateDBSnapshotRequest createDBSnapshotRequest = new CreateDBSnapshotRequest().withDBInstanceIdentifier(this.dBInstanceIdentifier).withDBSnapshotIdentifier(this.dBSnapshotIdentifier);
        this.info("Starting RDS Snapshot '%s' at '%s'", this.dBSnapshotIdentifier, this.dBInstanceIdentifier);
        long startTime = System.currentTimeMillis();
        DBSnapshot snapshot = client.createDBSnapshot(createDBSnapshotRequest);
        this.info("Backing up... please wait.", new Object[0]);
        while (!this.isDone(snapshot)) {
            try {
                Thread.sleep(5000L);
                snapshot = this.describeSnapshot(client);
                if (snapshot != null) continue;
                break;
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Interrupted while waiting", (Exception)e);
            }
        }
        long endTime = System.currentTimeMillis();
        this.info("Snapshot took %d ms", endTime - startTime);
    }

    private boolean isDone(DBSnapshot snapshot) {
        String status = snapshot.getStatus();
        return "available".equalsIgnoreCase(status);
    }

    private Log logger() {
        return this.getLog();
    }
}

