/*
 * Decompiled with CFR 0.152.
 */
package br.com.mblabs.service;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.location.LocationManager;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.PowerManager;
import android.support.v4.app.NotificationCompat;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import br.com.mblabs.Notification;
import br.com.mblabs.service.ForegroundNotification;
import br.com.mblabs.service.LocationServiceListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class LocationService
extends Service {
    private static final String TAG = LocationService.class.getSimpleName();
    private static final String ANDROID_CHANNEL_SERVICE_ID = "location_service";
    private static final String ANDROID_CHANNEL_SERVICE = "Servi\u00e7o de localiza\u00e7\u00e3o";
    private PowerManager powerManager;
    private PowerManager.WakeLock wakeLock;
    private final IBinder iBinder = new LocalBinder();
    private final List<LocationListener> locationListeners = Arrays.asList(new LocationListener("gps"), new LocationListener("network"));
    private LocationManager locationManager;
    private List<LocationServiceListener> locationServiceListenerList = new ArrayList<LocationServiceListener>();

    protected abstract boolean isDebugMode();

    protected abstract int getForegroundId();

    protected abstract float getBestAccuracy();

    protected abstract String getNotificationTitle();

    protected abstract String getNotificationText();

    protected abstract int getNotificationColor();

    protected abstract int getNotificationSmallIcon();

    protected abstract String getActionTracking();

    protected abstract int getMinTime();

    protected abstract int getMinDistance();

    protected abstract LocationServiceListener getLocationServiceListener();

    protected abstract LocationServiceListener removeLocationServiceListener();

    private void addTrackingServiceListener() {
        if (!this.locationServiceListenerList.contains(this.getLocationServiceListener())) {
            this.locationServiceListenerList.add(this.getLocationServiceListener());
        }
    }

    private void removeTrackingServiceListener() {
        this.locationServiceListenerList.remove(this.removeLocationServiceListener());
    }

    private void sendOnLocationChangedEvents(Location location) {
        for (LocationServiceListener listener : this.locationServiceListenerList) {
            if (!(location.getAccuracy() <= this.getBestAccuracy())) continue;
            listener.onLocationChanged(location);
        }
    }

    private void sendOnTrackingStarted() {
        for (LocationServiceListener listener : this.locationServiceListenerList) {
            listener.onTrackingStarted();
        }
    }

    private void sendOnTrackingStop() {
        for (LocationServiceListener listener : this.locationServiceListenerList) {
            listener.onTrackingStop();
        }
    }

    private void sendOnGpsProviderDisabled() {
        for (LocationServiceListener listener : this.locationServiceListenerList) {
            listener.onGpsProviderDisabled("We need your location so we can follow up on your travels");
        }
    }

    private void sendOnGpsProviderEnabled() {
        for (LocationServiceListener listener : this.locationServiceListenerList) {
            listener.onGpsProviderEnabled();
        }
    }

    public final int onStartCommand(Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        this.logService("onStartCommand");
        if (intent != null && "br.com.mblabs.location.action.START_FOREGROUND".equals(intent.getAction())) {
            Log.i((String)TAG, (String)"Received Start Foreground Intent ");
            this.startForeground();
        } else if (intent != null && "br.com.mblabs.location.action.UPDATE_LOCATION_UPDATES".equals(intent.getAction())) {
            Log.i((String)TAG, (String)"Update location settings");
            this.updateLocationSettings();
            this.startForeground();
        } else if (intent != null && "br.com.mblabs.location.action.STOP_FOREGROUND".equals(intent.getAction())) {
            Log.i((String)TAG, (String)"Received Stop Foreground Intent");
            this.stopForeground(true);
            this.stopSelf();
        }
        return 1;
    }

    public void onCreate() {
        super.onCreate();
        this.logService("onCreate");
        this.powerManager = (PowerManager)this.getSystemService("power");
        this.wakeLock = this.powerManager.newWakeLock(1, this.getTag());
        this.handleSleepMode();
        this.locationManager = (LocationManager)this.getSystemService("location");
        this.requestLocationUpdates(this.getMinTime(), this.getMinDistance());
        this.addTrackingServiceListener();
        this.sendOnTrackingStarted();
    }

    private void updateLocationSettings() {
        this.locationManager = (LocationManager)this.getSystemService("location");
        this.requestLocationUpdates(this.getMinTime(), this.getMinDistance());
    }

    public void onDestroy() {
        this.logService("onDestroy");
        this.removeLocationUpdates();
        this.removeTrackingServiceListener();
        this.stopForeground(true);
        this.sendOnTrackingStop();
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return this.iBinder;
    }

    protected String getTag() {
        return TAG;
    }

    private void startForeground() {
        ForegroundNotification notification = this.getForegroundNotificationSpec();
        NotificationCompat.Builder builder = Notification.getBuilder((Context)this, notification.getChannelName(), notification.getChannel());
        builder.setOngoing(notification.isOngoing()).setContentTitle((CharSequence)notification.getTitle()).setContentText((CharSequence)notification.getText()).setColor(notification.getColor()).setSmallIcon(notification.getResourceId());
        if (notification.getIntent() != null) {
            builder.setContentIntent(notification.getIntent());
        }
        this.startForeground(notification.getId(), builder.build());
    }

    @TargetApi(value=26)
    public NotificationChannel getForegroundNotificationChannel() {
        NotificationChannel channelService = new NotificationChannel(ANDROID_CHANNEL_SERVICE_ID, (CharSequence)ANDROID_CHANNEL_SERVICE, 2);
        channelService.enableLights(true);
        channelService.enableVibration(false);
        channelService.setLightColor(-16711936);
        channelService.setLockscreenVisibility(1);
        return channelService;
    }

    protected ForegroundNotification getForegroundNotificationSpec() {
        ForegroundNotification notification = new ForegroundNotification();
        notification.setId(this.getForegroundId());
        notification.setText(this.getNotificationText());
        notification.setTitle(this.getNotificationTitle());
        notification.setResourceId(this.getNotificationSmallIcon());
        notification.setColor(ContextCompat.getColor((Context)this, (int)this.getNotificationColor()));
        if (Build.VERSION.SDK_INT >= 26) {
            notification.setChannel(this.getForegroundNotificationChannel());
            notification.setChannelName(ANDROID_CHANNEL_SERVICE_ID);
        }
        Intent launchIntent = this.getPackageManager().getLaunchIntentForPackage(this.getApplicationContext().getPackageName());
        PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)launchIntent, (int)0x10000000);
        notification.setIntent(pendingIntent);
        notification.setOngoing(true);
        return notification;
    }

    protected final void handleSleepMode() {
        if (Build.VERSION.SDK_INT >= 20) {
            if (!this.powerManager.isInteractive() && !this.wakeLock.isHeld()) {
                this.logService("Acquire lock");
                this.wakeLock.acquire();
            } else if (this.powerManager.isInteractive() && this.wakeLock.isHeld()) {
                this.logService("Release lock");
                this.wakeLock.release();
            }
        } else if (!this.powerManager.isScreenOn() && !this.wakeLock.isHeld()) {
            this.logService("Acquire lock");
            this.wakeLock.acquire();
        } else if (this.powerManager.isScreenOn() && this.wakeLock.isHeld()) {
            this.logService("Release lock");
            this.wakeLock.release();
        }
    }

    private void logService(String message) {
        if (this.isDebugMode()) {
            Log.i((String)this.getTag(), (String)message);
        }
    }

    private void requestLocationUpdates(long minTime, long minDistance) {
        for (LocationListener locationListener : this.locationListeners) {
            try {
                this.locationManager.requestLocationUpdates(locationListener.getProvider(), minTime, (float)minDistance, (android.location.LocationListener)locationListener);
            }
            catch (SecurityException ex) {
                this.logService("Fail to request location update, ignore: " + ex.getMessage());
            }
            catch (Exception ex) {
                this.logService("Fail to request location update, ignore: " + ex.getMessage());
            }
        }
    }

    private void removeLocationUpdates() {
        for (LocationListener locationListener : this.locationListeners) {
            try {
                this.locationManager.removeUpdates((android.location.LocationListener)locationListener);
            }
            catch (Exception ex) {
                this.logService("Fail to remove location provider, ignore: " + ex.getMessage());
            }
        }
    }

    private final class LocationListener
    implements android.location.LocationListener {
        private final String provider;

        LocationListener(String provider) {
            this.provider = provider;
        }

        String getProvider() {
            return this.provider;
        }

        public void onLocationChanged(Location location) {
            LocationService.this.sendOnLocationChangedEvents(location);
        }

        public void onProviderDisabled(String provider) {
            LocationService.this.logService(provider);
            if (provider.equals("gps")) {
                LocationService.this.sendOnGpsProviderDisabled();
            }
        }

        public void onProviderEnabled(String provider) {
            LocationService.this.logService(provider);
            if (provider.equals("gps")) {
                LocationService.this.sendOnGpsProviderEnabled();
            }
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            LocationService.this.logService(provider + " " + status + " " + extras.toString());
            LocationService.this.logService("onStatusChanged: " + provider + " " + this.convertProviderStatus(status));
        }

        private String convertProviderStatus(int status) {
            switch (status) {
                case 2: {
                    return "AVAILABLE";
                }
                case 1: {
                    return "TEMPORARILY_UNAVAILABLE";
                }
                case 0: {
                    return "OUT_OF_SERVICE";
                }
            }
            return "";
        }
    }

    public final class LocalBinder
    extends Binder {
        public LocationService getServiceInstance() {
            return LocationService.this;
        }
    }
}

