/*
 * Decompiled with CFR 0.152.
 */
package br.com.mblabs.location;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AlertDialog;
import android.util.Log;
import br.com.mblabs.location.GpsProviderEnableDialog;
import br.com.mblabs.location.LocationException;
import br.com.mblabs.location.LocationSdkListener;
import br.com.mblabs.location.LocationSdkPermission;
import br.com.mblabs.location.LocationSettingsListener;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationServices;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SuppressLint(value={"MissingPermission"})
public class LocationAPI {
    private static final String TAG = LocationAPI.class.getSimpleName();
    private static final String PREFERENCES = "br.com.mblabs.location.PREFERENCES";
    private static final String KEY_FIRST_TIME_ASK_PERMISSION = "br.com.mblabs.location.KEY_FIRST_TIME_ASK_PERMISSION";
    public static final String START_FOREGROUND_ACTION = "br.com.mblabs.location.action.START_FOREGROUND";
    public static final String UPDATE_LOCATION_UPDATES = "br.com.mblabs.location.action.UPDATE_LOCATION_UPDATES";
    public static final String STOP_FOREGROUND_ACTION = "br.com.mblabs.location.action.STOP_FOREGROUND";
    public static final int REQUEST_CODE_ACCESS_LOCATION = 9990;
    private final LocationManager locationManager;
    private static List<LocationSdkListener> locationSdkListeners = new ArrayList<LocationSdkListener>();

    private LocationAPI(Context context) throws LocationException {
        if (context == null) {
            throw new LocationException(LocationException.LocationErrorCode.CONTEXT_NULL);
        }
        this.locationManager = (LocationManager)context.getSystemService("location");
    }

    public void init() {
        for (LocationSdkListener locationSdkListener : locationSdkListeners) {
            this.requestLocationUpdates(locationSdkListener);
        }
    }

    public static void startService(Context context, Class<?> cls) {
        Intent startIntent = new Intent(context, cls);
        startIntent.setAction(START_FOREGROUND_ACTION);
        ContextCompat.startForegroundService((Context)context, (Intent)startIntent);
    }

    public static void stopService(Context context, Class<?> cls) {
        Intent stopIntent = new Intent(context, cls);
        context.stopService(stopIntent);
    }

    public static void updateService(Context context, Class<?> cls) {
        Intent updateIntent = new Intent(context, cls);
        updateIntent.setAction(UPDATE_LOCATION_UPDATES);
        ContextCompat.startForegroundService((Context)context, (Intent)updateIntent);
    }

    private void setListeners(List<LocationSdkListener> locationSdkListeners) {
        LocationAPI.locationSdkListeners = locationSdkListeners;
    }

    public static boolean hasNecessaryPermissions(Context context) {
        return ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0 && ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
    }

    public static void requestLocationPermissions(Activity activity, String[] permissions) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])permissions, (int)9990);
    }

    public static void checkLocationNecessarySettings(Activity activity, LocationSettingsListener listener, String title, String message, String positiveButtonText) {
        if (!LocationAPI.hasNecessaryPermissions(activity.getBaseContext())) {
            LocationAPI.requestLocationPermissions(activity, new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"});
        } else if (!LocationAPI.hasGpsDevice(activity.getBaseContext())) {
            listener.onDeviceNotSupportGps();
        } else if (!LocationAPI.isProviderEnabled(activity.getBaseContext(), "gps")) {
            GpsProviderEnableDialog.enableGpsProvider(activity);
        } else if (!LocationAPI.isIgnoringBatteryOptimizations(activity.getBaseContext())) {
            LocationAPI.checkIgnoringBatteryOptimizations(activity, title, message, positiveButtonText);
        } else {
            listener.onDeviceSettingsReady();
        }
    }

    public static boolean hasGpsDevice(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        if (locationManager == null) {
            return false;
        }
        List providers = locationManager.getAllProviders();
        return providers != null && providers.contains("gps");
    }

    public static boolean isProviderEnabled(Context context, String provider) {
        return ((LocationManager)Objects.requireNonNull(context.getSystemService("location"))).isProviderEnabled(provider);
    }

    public static boolean isIgnoringBatteryOptimizations(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            String packageName = context.getPackageName();
            PowerManager pm = (PowerManager)context.getSystemService("power");
            return pm.isIgnoringBatteryOptimizations(packageName);
        }
        return true;
    }

    public static void checkIgnoringBatteryOptimizations(Activity activity, String title, String message, String positiveButtonText) {
        try {
            Intent intent = new Intent();
            intent.setAction("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
            intent.setData(Uri.parse((String)("package:" + activity.getPackageName())));
            activity.startActivity(intent);
        }
        catch (Exception ex) {
            AlertDialog dialogIgnoreBatteryOptimizations = new AlertDialog.Builder((Context)activity).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton((CharSequence)positiveButtonText, (dialogInterface, i) -> dialogInterface.dismiss()).setCancelable(false).create();
            dialogIgnoreBatteryOptimizations.show();
        }
    }

    public static void onRequestPermissionsResult(Activity activity, int requestCode, String[] permissions, int[] grantResults, LocationSdkPermission locationSdkPermission) {
        if (requestCode == 9990) {
            for (int index = 0; index < permissions.length; ++index) {
                if (grantResults[index] == 0) continue;
                boolean showRationale = ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permissions[index]);
                if (!showRationale && !LocationAPI.permissionFirstTimeAsking((Context)activity)) {
                    LocationAPI.setPermissionFirstTimeAsking((Context)activity, false);
                    locationSdkPermission.onNeverAskAgain(permissions[index]);
                    return;
                }
                if (!LocationAPI.permissionFirstTimeAsking((Context)activity)) {
                    LocationAPI.setPermissionFirstTimeAsking((Context)activity, false);
                    locationSdkPermission.onShouldRequestPermissionRationale(permissions[index]);
                    return;
                }
                LocationAPI.setPermissionFirstTimeAsking((Context)activity, false);
                locationSdkPermission.onPermissionDenied(permissions[index]);
                return;
            }
            locationSdkPermission.onPermissionsGranted();
        }
    }

    private static boolean permissionFirstTimeAsking(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFERENCES, 0);
        return sharedPreferences.getBoolean(KEY_FIRST_TIME_ASK_PERMISSION, true);
    }

    private static void setPermissionFirstTimeAsking(Context context, boolean firstTimeAsking) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREFERENCES, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putBoolean(KEY_FIRST_TIME_ASK_PERMISSION, firstTimeAsking);
        editor.apply();
    }

    private void requestLocationUpdates(LocationSdkListener locationSdkListener) {
        try {
            this.locationManager.requestLocationUpdates(locationSdkListener.getProvider(), locationSdkListener.getMinTime(), locationSdkListener.getMinDistance(), (LocationListener)locationSdkListener);
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Fail to request location update, ignore", (Throwable)ex);
        }
    }

    public void removeLocationUpdates() {
        for (LocationSdkListener locationSdkListener : locationSdkListeners) {
            try {
                this.locationManager.removeUpdates((LocationListener)locationSdkListener);
            }
            catch (Exception ex) {
                Log.e((String)TAG, (String)"Fail to remove location provider, ignore", (Throwable)ex);
            }
        }
    }

    public static void lastKnowLocation(Activity activity, LocationSdkListener locationSdkListener) {
        FusedLocationProviderClient FusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)activity);
        FusedLocationClient.getLastLocation().addOnSuccessListener(activity, location -> {
            if (location != null) {
                locationSdkListener.onLocationChanged((Location)location);
            }
        });
    }

    public static class Builder {
        private final Context context;
        private final List<LocationSdkListener> listeners;

        public Builder(Context context) {
            this.context = context;
            this.listeners = new ArrayList<LocationSdkListener>();
        }

        public Builder addListener(LocationSdkListener locationSdkListener) {
            this.listeners.add(locationSdkListener);
            return this;
        }

        public LocationAPI build() throws LocationException {
            LocationAPI locationAPI = new LocationAPI(this.context);
            locationAPI.setListeners(this.listeners);
            return locationAPI;
        }

        public void init() throws LocationException {
            LocationAPI locationAPI = new LocationAPI(this.context);
            locationAPI.setListeners(this.listeners);
            locationAPI.init();
        }
    }
}

