/*
 * Decompiled with CFR 0.152.
 */
package br.com.mblabs.location;

import android.app.Activity;
import android.content.Context;
import android.content.IntentSender;
import android.os.Bundle;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;

public class GpsProviderEnableDialog {
    private static GoogleApiClient googleApiClient;
    private static LocationRequest locationRequest;
    public static int REQUEST_CHECK_SETTINGS;

    public static void enableGpsProvider(final Activity activity) {
        locationRequest = LocationRequest.create();
        locationRequest.setPriority(100);
        locationRequest.setInterval(30000L);
        locationRequest.setFastestInterval(5000L);
        googleApiClient = new GoogleApiClient.Builder((Context)activity).addApi(LocationServices.API).addConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(Bundle bundle) {
                LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
                builder.setAlwaysShow(true);
                PendingResult result = LocationServices.SettingsApi.checkLocationSettings(googleApiClient, builder.build());
                result.setResultCallback(locationSettingsResult -> {
                    Status status = locationSettingsResult.getStatus();
                    switch (status.getStatusCode()) {
                        case 0: {
                            break;
                        }
                        case 6: {
                            try {
                                status.startResolutionForResult(activity, REQUEST_CHECK_SETTINGS);
                            }
                            catch (IntentSender.SendIntentException sendIntentException) {}
                            break;
                        }
                    }
                });
            }

            public void onConnectionSuspended(int i) {
            }
        }).addOnConnectionFailedListener(connectionResult -> {}).build();
        googleApiClient.connect();
    }

    public static void disconnect() {
        if (googleApiClient != null && googleApiClient.isConnected()) {
            googleApiClient.disconnect();
        }
    }

    static {
        REQUEST_CHECK_SETTINGS = 9010;
    }
}

