/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.BuildAndUploadArchive;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerCommand;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerContext;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.WaitFor;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.ZeroDowntime;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.ListIterator;

public class DeployerChain {
    private List<DeployerCommand> commandList;
    private final DeployerContext c;

    public DeployerChain(DeployerContext deployerContext) {
        this.c = deployerContext;
    }

    public boolean perform() throws Exception {
        this.buildCommandList();
        ListIterator<DeployerCommand> itCommand = this.commandList.listIterator();
        boolean abortedOnPerform = false;
        Exception resultingException = null;
        while (itCommand.hasNext()) {
            boolean mustAbort;
            DeployerCommand nextCommand = itCommand.next();
            nextCommand.setDeployerContext(this.c);
            try {
                mustAbort = nextCommand.perform();
            }
            catch (Exception exc) {
                mustAbort = true;
                resultingException = exc;
            }
            if (!mustAbort) continue;
            abortedOnPerform = true;
            break;
        }
        while (itCommand.hasPrevious()) {
            DeployerCommand prevCommand = itCommand.previous();
            try {
                prevCommand.release();
            }
            catch (Exception exc) {
                resultingException = exc;
            }
        }
        if (null != resultingException) {
            throw resultingException;
        }
        return abortedOnPerform;
    }

    private void buildCommandList() {
        this.commandList = Lists.newArrayList((Object[])new DeployerCommand[]{new DeployerCommand.InitLogger(), new DeployerCommand.ValidateParameters(), new DeployerCommand.InitAWS(), new BuildAndUploadArchive(), new DeployerCommand.CreateApplicationVersion()});
        if (!this.c.config.isSkipEnvironmentUpdates()) {
            if (this.c.config.isZeroDowntime()) {
                this.commandList.add(new ZeroDowntime());
            } else {
                this.commandList.add(new DeployerCommand.LookupEnvironmentId());
                this.commandList.add(new DeployerCommand.AbortPendingUpdates());
                this.commandList.add(new DeployerCommand.WaitForEnvironment(WaitFor.Status).withoutVersionCheck());
                this.commandList.add(new DeployerCommand.UpdateApplicationVersion());
            }
            if (this.c.config.isCheckHealth()) {
                this.commandList.add(new DeployerCommand.WaitForEnvironment(WaitFor.Both));
            } else {
                this.commandList.add(new DeployerCommand.WaitForEnvironment(WaitFor.Status));
            }
            this.commandList.add(new DeployerCommand.MarkAsSuccessful());
            this.commandList.add(new DeployerCommand.VerifyVersion());
        }
    }
}

