/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerCommand;
import com.amazonaws.services.elasticbeanstalk.model.CreateStorageLocationResult;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.util.DirScanner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

@SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS", "OBL_UNSATISFIED_OBLIGATION"})
public class BuildAndUploadArchive
extends DeployerCommand {
    private File localArchive = null;

    @Override
    public boolean perform() throws Exception {
        this.localArchive = this.getLocalFileObject(this.getRootFileObject());
        this.log("Using archive '%s'", this.localArchive.getAbsolutePath());
        if (StringUtils.isBlank((String)this.c.config.getBucketName())) {
            this.log("bucketName not set. Calling createStorageLocation", new Object[0]);
            CreateStorageLocationResult storageLocation = this.getAwseb().createStorageLocation();
            this.log("Using s3 Bucket '%s'", storageLocation.getS3Bucket());
            this.c.config.setBucketName(storageLocation.getS3Bucket());
        }
        this.setObjectKey(Utils.formatPath("%s/%s-%s.zip", this.c.config.getKeyPrefix(), this.c.config.getApplicationName(), this.getVersionLabel()));
        this.setS3ObjectPath("s3://" + Utils.formatPath("%s/%s", this.c.config.getBucketName(), this.getObjectKey()));
        this.log("Uploading file %s as %s", this.localArchive.getName(), this.getS3ObjectPath());
        this.getS3().putObject(this.c.config.getBucketName(), this.getObjectKey(), this.localArchive);
        return false;
    }

    @Override
    public boolean release() {
        if (null != this.localArchive && this.localArchive.exists()) {
            this.log("Cleaning up temporary file %s", this.localArchive.getAbsolutePath());
            FileUtils.deleteQuietly((File)this.localArchive);
        }
        return false;
    }

    private File getLocalFileObject(FilePath rootFileObject) throws Exception {
        File resultFile = File.createTempFile("awseb-", ".zip");
        if (!rootFileObject.isDirectory()) {
            this.log("Root File Object is a file. We assume its a zip file, which is okay.", new Object[0]);
            rootFileObject.copyTo((OutputStream)new FileOutputStream(resultFile));
        } else {
            this.log("Zipping contents of Root File Object (%s) into tmp file %s (includes=%s, excludes=%s)", rootFileObject.getName(), resultFile.getName(), this.getConfig().getIncludes(), this.getConfig().getExcludes());
            rootFileObject.zip((OutputStream)new FileOutputStream(resultFile), (DirScanner)new DirScanner.Glob(this.getConfig().getIncludes(), this.getConfig().getExcludes()));
        }
        return resultFile;
    }
}

