/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSClientFactory;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentConfig;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Constants;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerContext;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.WaitFor;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.AbortEnvironmentUpdateRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.EventDescription;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.util.VersionInfoUtils;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;

public class DeployerCommand
implements Constants {
    protected DeployerContext c;

    public void setDeployerContext(DeployerContext c) {
        this.c = c;
    }

    public boolean perform() throws Exception {
        return false;
    }

    public boolean release() throws Exception {
        return false;
    }

    protected void log(String message, Object ... args) {
        this.getLogger().printf(message, args);
        this.getLogger().println();
    }

    public DeployerContext getC() {
        return this.c;
    }

    public void setC(DeployerContext c) {
        this.c = c;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeployerCommand)) {
            return false;
        }
        DeployerCommand other = (DeployerCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DeployerContext this$c = this.getC();
        DeployerContext other$c = other.getC();
        return !(this$c == null ? other$c != null : !((Object)this$c).equals(other$c));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeployerCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DeployerContext $c = this.getC();
        result = result * 59 + ($c == null ? 43 : ((Object)$c).hashCode());
        return result;
    }

    public String toString() {
        return "DeployerCommand(c=" + this.getC() + ")";
    }

    public AWSEBDeploymentConfig getDeployerConfig() {
        return this.getC().getDeployerConfig();
    }

    public FilePath getRootFileObject() {
        return this.getC().getRootFileObject();
    }

    public TaskListener getListener() {
        return this.getC().getListener();
    }

    public AmazonS3 getS3() {
        return this.getC().getS3();
    }

    public AWSElasticBeanstalk getAwseb() {
        return this.getC().getAwseb();
    }

    public PrintStream getLogger() {
        return this.getC().getLogger();
    }

    public String getKeyPrefix() {
        return this.getC().getKeyPrefix();
    }

    public String getBucketName() {
        return this.getC().getBucketName();
    }

    public String getApplicationName() {
        return this.getC().getApplicationName();
    }

    public String getVersionLabel() {
        return this.getC().getVersionLabel();
    }

    public String getVersionDescription() {
        return this.getC().getVersionDescription();
    }

    public String getObjectKey() {
        return this.getC().getObjectKey();
    }

    public String getS3ObjectPath() {
        return this.getC().getS3ObjectPath();
    }

    public String getEnvironmentName() {
        return this.getC().getEnvironmentName();
    }

    public String getEnvironmentId() {
        return this.getC().getEnvironmentId();
    }

    public boolean isSuccessfulP() {
        return this.getC().isSuccessfulP();
    }

    public void setS3(AmazonS3 s3) {
        this.getC().setS3(s3);
    }

    public void setAwseb(AWSElasticBeanstalk awseb) {
        this.getC().setAwseb(awseb);
    }

    public void setLogger(PrintStream logger) {
        this.getC().setLogger(logger);
    }

    public void setKeyPrefix(String keyPrefix) {
        this.getC().setKeyPrefix(keyPrefix);
    }

    public void setBucketName(String bucketName) {
        this.getC().setBucketName(bucketName);
    }

    public void setApplicationName(String applicationName) {
        this.getC().setApplicationName(applicationName);
    }

    public void setVersionLabel(String versionLabel) {
        this.getC().setVersionLabel(versionLabel);
    }

    public void setVersionDescription(String versionDescription) {
        this.getC().setVersionDescription(versionDescription);
    }

    public void setObjectKey(String objectKey) {
        this.getC().setObjectKey(objectKey);
    }

    public void setS3ObjectPath(String s3ObjectPath) {
        this.getC().setS3ObjectPath(s3ObjectPath);
    }

    public void setEnvironmentName(String environmentName) {
        this.getC().setEnvironmentName(environmentName);
    }

    public void setEnvironmentId(String environmentId) {
        this.getC().setEnvironmentId(environmentId);
    }

    public void setSuccessfulP(boolean successfulP) {
        this.getC().setSuccessfulP(successfulP);
    }

    public static class AbortPendingUpdates
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(this.getApplicationName()).withEnvironmentIds((Collection)Lists.newArrayList((Object[])this.getEnvironmentId().split(","))).withIncludeDeleted(Boolean.valueOf(false));
            DescribeEnvironmentsResult result = this.getAwseb().describeEnvironments(req);
            if (result.getEnvironments().size() < 1) {
                this.log("Environment w/ environmentId '%s' not found. Aborting.", this.getEnvironmentId());
                return true;
            }
            boolean abort = false;
            Integer i = 0;
            while (i < result.getEnvironments().size()) {
                String resultingStatus = ((EnvironmentDescription)result.getEnvironments().get(i)).getStatus();
                boolean abortableP = ((EnvironmentDescription)result.getEnvironments().get(i)).getAbortableOperationInProgress();
                String environmentId = ((EnvironmentDescription)result.getEnvironments().get(i)).getEnvironmentId();
                if (!"Ready".equals(resultingStatus)) {
                    if (abortableP) {
                        this.log("AWS Abortable Environment Update Found. Calling abort on AWSEB Service", new Object[0]);
                        this.getAwseb().abortEnvironmentUpdate(new AbortEnvironmentUpdateRequest().withEnvironmentId(environmentId));
                        this.log("Environment Update Aborted. Proceeding.", new Object[0]);
                        abort = true;
                    }
                } else {
                    this.log("No pending Environment Updates. Proceeding.", new Object[0]);
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            if (abort) {
                WaitForEnvironment waitForStatus = new WaitForEnvironment(WaitFor.Status).withoutVersionCheck();
                waitForStatus.setDeployerContext(this.c);
                return waitForStatus.perform();
            }
            return false;
        }
    }

    public static class MarkAsSuccessful
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            this.log("Deployment marked as 'successful'. Starting post-deployment cleanup.", new Object[0]);
            this.setSuccessfulP(true);
            return false;
        }
    }

    @SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    public static class WaitForEnvironment
    extends DeployerCommand {
        final WaitFor waitFor;
        boolean versionCheck;

        public WaitForEnvironment(WaitFor waitFor) {
            this.waitFor = waitFor;
            this.versionCheck = true;
        }

        public WaitForEnvironment withoutVersionCheck() {
            this.versionCheck = false;
            return this;
        }

        @Override
        public boolean perform() throws Exception {
            ArrayList environmentIds = Lists.newArrayList((Object[])this.getEnvironmentId().split(","));
            if (environmentIds.size() < 1) {
                this.log("Environment not found. Aborting", new Object[0]);
                return true;
            }
            boolean moveOn = false;
            Integer i = 0;
            while (i < environmentIds.size()) {
                Integer maxAttempts = this.getDeployerConfig().getMaxAttempts() != null ? this.getDeployerConfig().getMaxAttempts() : 30;
                moveOn = false;
                for (int nAttempt = 1; nAttempt <= maxAttempts; ++nAttempt) {
                    boolean bHasDifferentVersion;
                    List environments = this.getAwseb().describeEnvironments(new DescribeEnvironmentsRequest().withEnvironmentIds((Collection)Lists.newArrayList((Object[])this.getEnvironmentId().split(","))).withIncludeDeleted(Boolean.valueOf(false))).getEnvironments();
                    String currentEnvironmentId = ((EnvironmentDescription)environments.get(i)).getEnvironmentId();
                    EnvironmentDescription environmentDescription = (EnvironmentDescription)environments.get(i);
                    Long lastMessageTimestamp = System.currentTimeMillis();
                    if (moveOn) break;
                    DescribeEventsResult describeEventsResult = this.getAwseb().describeEvents(new DescribeEventsRequest().withEnvironmentId(currentEnvironmentId).withStartTime(new Date(lastMessageTimestamp)));
                    for (EventDescription eventDescription : describeEventsResult.getEvents()) {
                        this.log("%s [%s] %s", eventDescription.getEventDate(), eventDescription.getSeverity(), eventDescription.getMessage());
                        lastMessageTimestamp = Math.max(eventDescription.getEventDate().getTime(), lastMessageTimestamp);
                    }
                    Integer sleepTime = this.getDeployerConfig().getSleepTime() != null ? this.getDeployerConfig().getSleepTime() : 90;
                    Thread.sleep(TimeUnit.SECONDS.toMillis(sleepTime.intValue()));
                    this.log("Checking health/status of environmentId %s attempt %d/%s", currentEnvironmentId, nAttempt, maxAttempts);
                    boolean bl = bHasDifferentVersion = !this.getVersionLabel().equals(this.getVersionLabel());
                    if (this.versionCheck) {
                        this.log("Versions reported: (current: %s, underDeployment: %s). Should I move on? %s", environmentDescription.getVersionLabel(), this.getVersionLabel(), String.valueOf(bHasDifferentVersion));
                        if (bHasDifferentVersion) continue;
                    }
                    boolean bHealthyP = "Green".equals(environmentDescription.getHealth());
                    boolean bReadyP = "Ready".equals(environmentDescription.getStatus());
                    if (WaitFor.Health == this.waitFor) {
                        if (!bHealthyP) continue;
                        this.log("Environment Health is 'Green'. Moving on.", new Object[0]);
                        moveOn = true;
                        continue;
                    }
                    if (WaitFor.Status == this.waitFor) {
                        if (!bReadyP) continue;
                        this.log("Environment Status is 'Ready'. Moving on.", new Object[0]);
                        moveOn = true;
                        continue;
                    }
                    if (WaitFor.Both != this.waitFor || !bReadyP || !bHealthyP) continue;
                    this.log("Environment Status is 'Ready' and Health is 'Green'. Moving on.", new Object[0]);
                    moveOn = true;
                }
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
            if (moveOn) {
                return false;
            }
            this.log("Environment Update timed-out. Aborting.", new Object[0]);
            return true;
        }

        protected boolean checkVersionLabel(String deployedVersionLabel) throws Exception {
            return this.getVersionLabel().equals(deployedVersionLabel);
        }
    }

    public static class UpdateApplicationVersion
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            ArrayList environmentIds = Lists.newArrayList((Object[])this.getEnvironmentId().split(","));
            ListIterator i = environmentIds.listIterator();
            while (i.hasNext()) {
                String element = (String)i.next();
                UpdateEnvironmentRequest req = new UpdateEnvironmentRequest().withEnvironmentId(element).withVersionLabel(this.getVersionLabel()).withDescription(this.getVersionDescription());
                this.log("Updating environmentId '%s' with Version Label set to '%s'", element, this.getVersionLabel());
                this.getAwseb().updateEnvironment(req);
            }
            return false;
        }
    }

    public static class LookupEnvironmentId
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            DescribeEnvironmentsRequest req = new DescribeEnvironmentsRequest().withApplicationName(this.getApplicationName()).withEnvironmentNames((Collection)Lists.newArrayList((Object[])this.getEnvironmentName().replaceAll("\\s", "").split(","))).withIncludeDeleted(Boolean.valueOf(false));
            DescribeEnvironmentsResult result = this.getAwseb().describeEnvironments(req);
            if (result.getEnvironments().size() < 1) {
                this.log("Unable to lookup environmentId. Skipping Update.", new Object[0]);
                return true;
            }
            StringBuilder csEnvironmentIds = new StringBuilder();
            ListIterator i = result.getEnvironments().listIterator();
            while (i.hasNext()) {
                EnvironmentDescription element = (EnvironmentDescription)i.next();
                String environmentLabel = element.getVersionLabel();
                if (null != environmentLabel && environmentLabel.equals(this.getVersionLabel())) {
                    this.log("The version to deploy and currently used are the same. Even if you overwrite, AWSEB won't allow you to update.Skipping.", new Object[0]);
                    csEnvironmentIds.append(element.getEnvironmentId());
                    if (!i.hasNext()) continue;
                    csEnvironmentIds.append(",");
                    continue;
                }
                String environmentId = element.getEnvironmentId();
                this.log("Using environmentId '%s'", environmentId);
                csEnvironmentIds.append(environmentId);
                if (!i.hasNext()) continue;
                csEnvironmentIds.append(",");
            }
            this.setEnvironmentId(csEnvironmentIds.toString());
            return false;
        }
    }

    public static class CreateApplicationVersion
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            this.log("Creating application version %s for application %s for path %s", this.getVersionLabel(), this.getApplicationName(), this.getS3ObjectPath());
            CreateApplicationVersionRequest cavRequest = new CreateApplicationVersionRequest().withApplicationName(this.getApplicationName()).withAutoCreateApplication(Boolean.valueOf(true)).withSourceBundle(new S3Location(this.getBucketName(), this.getObjectKey())).withVersionLabel(this.getVersionLabel()).withDescription(this.getVersionDescription());
            CreateApplicationVersionResult result = this.getAwseb().createApplicationVersion(cavRequest);
            this.log("Created version: %s", result.getApplicationVersion().getVersionLabel());
            return false;
        }
    }

    public static class InitAWS
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            AWSClientFactory factory = null != this.getDeployerConfig().getCredentials() ? AWSClientFactory.getClientFactory(this.getDeployerConfig().getCredentials(), this.getDeployerConfig().getAwsRegion()) : AWSClientFactory.getClientFactory("", this.getDeployerConfig().getAwsRegion());
            this.log("Using region: '%s'", this.getDeployerConfig().getAwsRegion());
            this.setS3((AmazonS3)factory.getService(AmazonS3Client.class));
            this.setAwseb((AWSElasticBeanstalk)factory.getService(AWSElasticBeanstalkClient.class));
            return false;
        }
    }

    public static class ValidateParameters
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            this.setKeyPrefix(this.getDeployerConfig().getKeyPrefix());
            this.setBucketName(this.getDeployerConfig().getBucketName());
            this.setApplicationName(this.getDeployerConfig().getApplicationName());
            this.setVersionLabel(this.getDeployerConfig().getVersionLabelFormat());
            this.setVersionDescription(this.getDeployerConfig().getVersionDescriptionFormat());
            this.setEnvironmentName(this.getDeployerConfig().getEnvironmentName());
            Validate.notEmpty((String)this.getEnvironmentName(), (String)"Empty/blank environmentName parameter");
            Validate.notEmpty((String)this.getApplicationName(), (String)"Empty/blank applicationName parameter");
            Validate.notEmpty((String)this.getVersionLabel(), (String)"Empty/blank versionLabel parameter");
            Validate.isTrue((boolean)this.getRootFileObject().exists(), (String)"Root Object doesn't exist");
            return false;
        }
    }

    public static class InitLogger
    extends DeployerCommand {
        @Override
        public boolean perform() throws Exception {
            if (null == this.getLogger()) {
                this.setLogger(this.getListener().getLogger());
            }
            this.log("AWSEB Deployment Plugin Version %s (aws-java-sdk version: %s)", Utils.getVersion(), VersionInfoUtils.getVersion());
            return false;
        }
    }
}

