/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSClientFactory;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentBuilder;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.AWSEBDeploymentConfig;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.SlaveDeployerCallable;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.cmd.DeployerContext;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Future;
import org.apache.commons.lang.StringUtils;

public class DeployerRunner {
    final Run<?, ?> build;
    final Launcher launcher;
    final TaskListener listener;
    final AWSEBDeploymentBuilder deploymentBuilder;
    final FilePath workspace;

    public DeployerRunner(Run<?, ?> build, FilePath ws, Launcher launcher, TaskListener listener, AWSEBDeploymentBuilder deploymentBuilder) {
        this.build = build;
        this.launcher = launcher;
        this.listener = listener;
        this.deploymentBuilder = deploymentBuilder;
        this.workspace = ws;
    }

    public boolean perform() throws Exception {
        AWSEBDeploymentConfig deploymentConfig = this.deploymentBuilder.asConfig().replacedCopy(new Utils.Replacer(this.build, this.workspace, this.listener));
        FilePath rootFileObject = new FilePath(this.workspace, deploymentConfig.getRootObject());
        DeployerContext deployerContext = new DeployerContext(deploymentConfig, rootFileObject, this.listener);
        if (!StringUtils.isBlank((String)deploymentConfig.getCredentialId())) {
            deploymentConfig.setCredentials(AWSClientFactory.lookupNamedCredential(deploymentConfig.getCredentialId()));
        }
        Future booleanFuture = this.launcher.getChannel().callAsync((Callable)new SlaveDeployerCallable(deployerContext));
        return (Boolean)booleanFuture.get();
    }
}

