/*
 * Decompiled with CFR 0.152.
 */
package br.com.ingenieux.jenkins.plugins.awsebdeployment;

import br.com.ingenieux.jenkins.plugins.awsebdeployment.Constants;
import br.com.ingenieux.jenkins.plugins.awsebdeployment.Utils;
import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSCredentialsProviderChain;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.s3.AmazonS3;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.ProxyConfiguration;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import javax.security.auth.login.CredentialNotFoundException;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.reflect.ConstructorUtils;
import org.apache.commons.lang.reflect.FieldUtils;

public class AWSClientFactory
implements Constants {
    private AWSCredentialsProvider creds;
    private ClientConfiguration clientConfiguration;
    private String region;

    private AWSClientFactory(AWSCredentialsProvider creds, ClientConfiguration clientConfiguration, String region) {
        this.creds = creds;
        this.clientConfiguration = clientConfiguration;
        this.region = region.toLowerCase();
    }

    public static AWSClientFactory getClientFactory(AmazonWebServicesCredentials cred, String awsRegion) {
        DefaultAWSCredentialsProviderChain credentials = new DefaultAWSCredentialsProviderChain();
        if (null != cred) {
            credentials = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new StaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(cred.getCredentials().getAWSAccessKeyId(), cred.getCredentials().getAWSSecretKey()))});
        }
        ClientConfiguration clientConfig = new ClientConfiguration();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && jenkins.proxy != null) {
            ProxyConfiguration proxyConfig = jenkins.proxy;
            clientConfig.setProxyHost(proxyConfig.name);
            clientConfig.setProxyPort(proxyConfig.port);
            if (proxyConfig.getUserName() != null) {
                clientConfig.setProxyUsername(proxyConfig.getUserName());
                clientConfig.setProxyPassword(proxyConfig.getPassword());
            }
        }
        clientConfig.setUserAgent("ingenieux CloudButler/" + Utils.getVersion());
        return new AWSClientFactory((AWSCredentialsProvider)credentials, clientConfig, awsRegion);
    }

    public static AWSClientFactory getClientFactory(String credentialsId, String awsRegion) throws CredentialNotFoundException {
        AmazonWebServicesCredentials cred = null;
        if (StringUtils.isNotBlank((String)credentialsId)) {
            cred = AWSClientFactory.lookupNamedCredential(credentialsId);
        }
        return AWSClientFactory.getClientFactory(cred, awsRegion);
    }

    public static AmazonWebServicesCredentials lookupNamedCredential(String credentialsId) throws CredentialNotFoundException {
        List credentialList = CredentialsProvider.lookupCredentials(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, Collections.emptyList());
        AmazonWebServicesCredentials cred = (AmazonWebServicesCredentials)CredentialsMatchers.firstOrNull((Iterable)credentialList, (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId)}));
        if (cred == null) {
            throw new CredentialNotFoundException(credentialsId);
        }
        return cred;
    }

    public <T> T getService(Class<T> serviceClazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class[] paramTypes = new Class[]{AWSCredentialsProvider.class, ClientConfiguration.class};
        ClientConfiguration newClientConfiguration = new ClientConfiguration(this.clientConfiguration);
        newClientConfiguration = AmazonS3.class.isAssignableFrom(serviceClazz) ? newClientConfiguration.withSignerOverride("AWSS3V4SignerType") : newClientConfiguration.withSignerOverride(null);
        Object[] params = new Object[]{this.creds, newClientConfiguration};
        Object resultObj = ConstructorUtils.invokeConstructor(serviceClazz, (Object[])params, (Class[])paramTypes);
        if ("us-east-1".equals(StringUtils.defaultString((String)this.region, (String)"us-east-1"))) {
            return (T)resultObj;
        }
        for (ServiceEndpointFormatter formatter : ServiceEndpointFormatter.values()) {
            if (!formatter.matches(resultObj)) continue;
            ((AmazonWebServiceClient)resultObj).setEndpoint(this.getEndpointFor(formatter));
            break;
        }
        return (T)resultObj;
    }

    protected String getEndpointFor(ServiceEndpointFormatter formatter) {
        String endpointStr = String.format(formatter.serviceMask, this.region);
        if (this.region.equalsIgnoreCase("cn-north-1") && (endpointStr = endpointStr + ".cn").equalsIgnoreCase("s3-cn-north-1.amazonaws.com.cn")) {
            endpointStr = "s3.cn-north-1.amazonaws.com.cn";
        }
        return endpointStr;
    }

    public <T extends AmazonWebServiceClient> String getEndpointFor(T client) {
        try {
            URI endpointUri = (URI)FieldUtils.readField(client, (String)"endpoint", (boolean)true);
            return endpointUri.toASCIIString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static enum ServiceEndpointFormatter {
        ELASTICBEANSTALK(AWSElasticBeanstalk.class, "elasticbeanstalk.%s.amazonaws.com"),
        S3(AmazonS3.class, "s3-%s.amazonaws.com");

        final Class<?> serviceClass;
        final String serviceMask;

        private ServiceEndpointFormatter(Class<?> serviceClass, String serviceMask) {
            this.serviceClass = serviceClass;
            this.serviceMask = serviceMask;
        }

        public boolean matches(Object obj) {
            return this.serviceClass.isAssignableFrom(obj.getClass());
        }
    }
}

