/*
 * Decompiled with CFR 0.152.
 */
package br.com.edsilfer.kotlin_support.service.files;

import android.util.Log;
import java.io.File;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mf.javax.xml.transform.Source;
import mf.javax.xml.transform.stream.StreamSource;
import mf.org.apache.xerces.jaxp.validation.XMLSchemaFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lbr/com/edsilfer/kotlin_support/service/files/XMLValidator;", "", "()V", "validateAgainstSchema", "", "xml", "Ljava/io/InputStream;", "schema", "", "kotlin-support_release"})
public final class XMLValidator {
    public static final XMLValidator INSTANCE;

    public final boolean validateAgainstSchema(@NotNull String xml, @NotNull String schema) {
        Intrinsics.checkParameterIsNotNull((Object)xml, (String)"xml");
        Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
        XMLSchemaFactory factory = new XMLSchemaFactory();
        StreamSource schemaFile = new StreamSource(new File(schema));
        StreamSource xmlSource = new StreamSource(new File(xml));
        factory.newSchema((Source)schemaFile).newValidator().validate((Source)xmlSource);
        return true;
    }

    public final boolean validateAgainstSchema(@Nullable InputStream xml, @Nullable InputStream schema) {
        try {
            new XMLSchemaFactory().newSchema((Source)new StreamSource(schema)).newValidator().validate((Source)new StreamSource(xml));
        }
        catch (Exception e) {
            Log.e((String)"XMLValidator", (String)("Validation not passed due to following error: " + e.getMessage() + ". Given XML is not compliant with given XSD"));
            return false;
        }
        return true;
    }

    private XMLValidator() {
        INSTANCE = this;
    }

    static {
        new XMLValidator();
    }
}

