/*
 * Decompiled with CFR 0.152.
 */
package br.com.edsilfer.kotlin_support.service;

import android.util.Log;
import br.com.edsilfer.kotlin_support.model.Events;
import br.com.edsilfer.kotlin_support.model.ISubscriber;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lbr/com/edsilfer/kotlin_support/service/NotificationCenter;", "", "()V", "mSubscribers", "Ljava/util/HashMap;", "Lbr/com/edsilfer/kotlin_support/model/Events;", "", "Lbr/com/edsilfer/kotlin_support/model/ISubscriber;", "notify", "", "event", "payload", "RegistrationManager", "kotlin-support_release"})
public final class NotificationCenter {
    private static final HashMap<Events, Set<ISubscriber>> mSubscribers;
    public static final NotificationCenter INSTANCE;

    public final void notify(@NotNull Events event, @Nullable Object payload) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        Set<ISubscriber> subscribers = mSubscribers.get(event);
        if (subscribers != null) {
            for (ISubscriber s : subscribers) {
                s.onEventTriggered(event, payload);
            }
        } else {
            Log.i((String)Reflection.getOrCreateKotlinClass(NotificationCenter.class).getSimpleName(), (String)("There are no subscribers to process the " + event + "."));
        }
    }

    private NotificationCenter() {
        INSTANCE = this;
        mSubscribers = MapsKt.hashMapOf((Pair[])new Pair[0]);
    }

    static {
        new NotificationCenter();
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getMSubscribers$p(NotificationCenter $this) {
        NotificationCenter notificationCenter = $this;
        return mSubscribers;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\n"}, d2={"Lbr/com/edsilfer/kotlin_support/service/NotificationCenter$RegistrationManager;", "", "()V", "registerForEvent", "", "event", "Lbr/com/edsilfer/kotlin_support/model/Events;", "subscriber", "Lbr/com/edsilfer/kotlin_support/model/ISubscriber;", "unregisterForEvent", "kotlin-support_release"})
    public static final class RegistrationManager {
        public static final RegistrationManager INSTANCE;

        public final void registerForEvent(@NotNull Events event, @NotNull ISubscriber subscriber) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Intrinsics.checkParameterIsNotNull((Object)subscriber, (String)"subscriber");
            Set subscribers = (Set)NotificationCenter.access$getMSubscribers$p(INSTANCE).get(event);
            if (subscribers != null) {
                Set set = (Set)NotificationCenter.access$getMSubscribers$p(INSTANCE).get(event);
                if (set != null) {
                    set.add(subscriber);
                }
            } else {
                subscribers = SetsKt.mutableSetOf((Object[])new ISubscriber[]{subscriber});
                subscribers.add(subscriber);
                Map map = NotificationCenter.access$getMSubscribers$p(INSTANCE);
                Set set = subscribers;
                map.put(event, set);
            }
        }

        public final void unregisterForEvent(@NotNull Events event, @NotNull ISubscriber subscriber) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Intrinsics.checkParameterIsNotNull((Object)subscriber, (String)"subscriber");
            Set subscribers = (Set)NotificationCenter.access$getMSubscribers$p(INSTANCE).get(event);
            if (subscribers != null) {
                if (subscribers.contains(subscriber)) {
                    subscribers.remove(subscriber);
                } else {
                    Log.e((String)Reflection.getOrCreateKotlinClass(RegistrationManager.class).getSimpleName(), (String)"Subscribers was not registered for the given event.");
                }
            } else {
                Log.e((String)Reflection.getOrCreateKotlinClass(RegistrationManager.class).getSimpleName(), (String)"There are no subscribers for the given event.");
            }
        }

        private RegistrationManager() {
            INSTANCE = this;
        }

        static {
            new RegistrationManager();
        }
    }
}

