/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.jaxp.validation;

import java.io.IOException;
import java.util.Enumeration;
import mf.javax.xml.parsers.DocumentBuilder;
import mf.javax.xml.parsers.DocumentBuilderFactory;
import mf.javax.xml.parsers.ParserConfigurationException;
import mf.javax.xml.transform.Result;
import mf.javax.xml.transform.Source;
import mf.javax.xml.transform.dom.DOMResult;
import mf.javax.xml.transform.dom.DOMSource;
import mf.org.apache.xerces.dom.NodeImpl;
import mf.org.apache.xerces.impl.XMLErrorReporter;
import mf.org.apache.xerces.impl.validation.EntityState;
import mf.org.apache.xerces.impl.validation.ValidationManager;
import mf.org.apache.xerces.impl.xs.XMLSchemaValidator;
import mf.org.apache.xerces.impl.xs.util.SimpleLocator;
import mf.org.apache.xerces.jaxp.validation.DOMDocumentHandler;
import mf.org.apache.xerces.jaxp.validation.DOMResultAugmentor;
import mf.org.apache.xerces.jaxp.validation.DOMResultBuilder;
import mf.org.apache.xerces.jaxp.validation.JAXPValidationMessageFormatter;
import mf.org.apache.xerces.jaxp.validation.Util;
import mf.org.apache.xerces.jaxp.validation.ValidatorHelper;
import mf.org.apache.xerces.jaxp.validation.XMLSchemaValidatorComponentManager;
import mf.org.apache.xerces.util.NamespaceSupport;
import mf.org.apache.xerces.util.SymbolTable;
import mf.org.apache.xerces.util.XMLAttributesImpl;
import mf.org.apache.xerces.util.XMLSymbols;
import mf.org.apache.xerces.xni.NamespaceContext;
import mf.org.apache.xerces.xni.QName;
import mf.org.apache.xerces.xni.XMLString;
import mf.org.apache.xerces.xni.XNIException;
import mf.org.apache.xerces.xni.parser.XMLParseException;
import mf.org.w3c.dom.Attr;
import mf.org.w3c.dom.CDATASection;
import mf.org.w3c.dom.Comment;
import mf.org.w3c.dom.Document;
import mf.org.w3c.dom.DocumentType;
import mf.org.w3c.dom.Entity;
import mf.org.w3c.dom.NamedNodeMap;
import mf.org.w3c.dom.Node;
import mf.org.w3c.dom.ProcessingInstruction;
import mf.org.w3c.dom.Text;
import org.xml.sax.SAXException;

final class DOMValidatorHelper
implements ValidatorHelper,
EntityState {
    private static final int CHUNK_SIZE = 1024;
    private static final int CHUNK_MASK = 1023;
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String NAMESPACE_CONTEXT = "http://apache.org/xml/properties/internal/namespace-context";
    private static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private final XMLErrorReporter fErrorReporter;
    private final NamespaceSupport fNamespaceContext;
    private final DOMNamespaceContext fDOMNamespaceContext = new DOMNamespaceContext();
    private final XMLSchemaValidator fSchemaValidator;
    private final SymbolTable fSymbolTable;
    private final ValidationManager fValidationManager;
    private final XMLSchemaValidatorComponentManager fComponentManager;
    private final SimpleLocator fXMLLocator = new SimpleLocator(null, null, -1, -1, -1);
    private DOMDocumentHandler fDOMValidatorHandler;
    private final DOMResultAugmentor fDOMResultAugmentor = new DOMResultAugmentor(this);
    private final DOMResultBuilder fDOMResultBuilder = new DOMResultBuilder();
    private NamedNodeMap fEntities = null;
    private final char[] fCharBuffer = new char[1024];
    private Node fRoot;
    private Node fCurrentElement;
    final QName fElementQName = new QName();
    final QName fAttributeQName = new QName();
    final XMLAttributesImpl fAttributes = new XMLAttributesImpl();
    final XMLString fTempString = new XMLString();

    public DOMValidatorHelper(XMLSchemaValidatorComponentManager componentManager) {
        this.fComponentManager = componentManager;
        this.fErrorReporter = (XMLErrorReporter)this.fComponentManager.getProperty(ERROR_REPORTER);
        this.fNamespaceContext = (NamespaceSupport)this.fComponentManager.getProperty(NAMESPACE_CONTEXT);
        this.fSchemaValidator = (XMLSchemaValidator)this.fComponentManager.getProperty(SCHEMA_VALIDATOR);
        this.fSymbolTable = (SymbolTable)this.fComponentManager.getProperty(SYMBOL_TABLE);
        this.fValidationManager = (ValidationManager)this.fComponentManager.getProperty(VALIDATION_MANAGER);
    }

    @Override
    public void validate(Source source, Result result) throws SAXException, IOException {
        if (result instanceof DOMResult || result == null) {
            Node node;
            DOMSource domSource = (DOMSource)source;
            DOMResult domResult = (DOMResult)result;
            this.fRoot = node = domSource.getNode();
            if (node != null) {
                this.fComponentManager.reset();
                this.fValidationManager.setEntityState(this);
                this.fDOMNamespaceContext.reset();
                String systemId = domSource.getSystemId();
                this.fXMLLocator.setLiteralSystemId(systemId);
                this.fXMLLocator.setExpandedSystemId(systemId);
                this.fErrorReporter.setDocumentLocator(this.fXMLLocator);
                try {
                    try {
                        this.setupEntityMap(node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument());
                        this.setupDOMResultHandler(domSource, domResult);
                        this.fSchemaValidator.startDocument(this.fXMLLocator, null, this.fDOMNamespaceContext, null);
                        this.validate(node);
                        this.fSchemaValidator.endDocument(null);
                    }
                    catch (XMLParseException e) {
                        throw Util.toSAXParseException(e);
                    }
                    catch (XNIException e) {
                        throw Util.toSAXException(e);
                    }
                }
                finally {
                    this.fRoot = null;
                    this.fCurrentElement = null;
                    this.fEntities = null;
                    if (this.fDOMValidatorHandler != null) {
                        this.fDOMValidatorHandler.setDOMResult(null);
                    }
                }
            }
            return;
        }
        throw new IllegalArgumentException(JAXPValidationMessageFormatter.formatMessage(this.fComponentManager.getLocale(), "SourceResultMismatch", new Object[]{source.getClass().getName(), result.getClass().getName()}));
    }

    @Override
    public boolean isEntityDeclared(String name) {
        return false;
    }

    @Override
    public boolean isEntityUnparsed(String name) {
        Entity entity;
        if (this.fEntities != null && (entity = (Entity)this.fEntities.getNamedItem(name)) != null) {
            return entity.getNotationName() != null;
        }
        return false;
    }

    private void validate(Node node) {
        Node top = node;
        boolean useIsSameNode = this.useIsSameNode(top);
        while (node != null) {
            this.beginNode(node);
            Node next = node.getFirstChild();
            while (next == null) {
                this.finishNode(node);
                if (top == node) break;
                next = node.getNextSibling();
                if (next != null || (node = node.getParentNode()) != null && !(useIsSameNode ? top.isSameNode(node) : top == node)) continue;
                if (node != null) {
                    this.finishNode(node);
                }
                next = null;
                break;
            }
            node = next;
        }
    }

    private void beginNode(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.fCurrentElement = node;
                this.fNamespaceContext.pushContext();
                this.fillQName(this.fElementQName, node);
                this.processAttributes(node.getAttributes());
                this.fSchemaValidator.startElement(this.fElementQName, this.fAttributes, null);
                break;
            }
            case 3: {
                if (this.fDOMValidatorHandler != null) {
                    this.fDOMValidatorHandler.setIgnoringCharacters(true);
                    this.sendCharactersToValidator(node.getNodeValue());
                    this.fDOMValidatorHandler.setIgnoringCharacters(false);
                    this.fDOMValidatorHandler.characters((Text)node);
                    break;
                }
                this.sendCharactersToValidator(node.getNodeValue());
                break;
            }
            case 4: {
                if (this.fDOMValidatorHandler != null) {
                    this.fDOMValidatorHandler.setIgnoringCharacters(true);
                    this.fSchemaValidator.startCDATA(null);
                    this.sendCharactersToValidator(node.getNodeValue());
                    this.fSchemaValidator.endCDATA(null);
                    this.fDOMValidatorHandler.setIgnoringCharacters(false);
                    this.fDOMValidatorHandler.cdata((CDATASection)node);
                    break;
                }
                this.fSchemaValidator.startCDATA(null);
                this.sendCharactersToValidator(node.getNodeValue());
                this.fSchemaValidator.endCDATA(null);
                break;
            }
            case 7: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.processingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.comment((Comment)node);
                break;
            }
            case 10: {
                if (this.fDOMValidatorHandler == null) break;
                this.fDOMValidatorHandler.doctypeDecl((DocumentType)node);
                break;
            }
        }
    }

    private void finishNode(Node node) {
        if (node.getNodeType() == 1) {
            this.fCurrentElement = node;
            this.fillQName(this.fElementQName, node);
            this.fSchemaValidator.endElement(this.fElementQName, null);
            this.fNamespaceContext.popContext();
        }
    }

    private void setupEntityMap(Document doc) {
        DocumentType docType;
        if (doc != null && (docType = doc.getDoctype()) != null) {
            this.fEntities = docType.getEntities();
            return;
        }
        this.fEntities = null;
    }

    private void setupDOMResultHandler(DOMSource source, DOMResult result) throws SAXException {
        if (result == null) {
            this.fDOMValidatorHandler = null;
            this.fSchemaValidator.setDocumentHandler(null);
            return;
        }
        Node nodeResult = result.getNode();
        if (source.getNode() == nodeResult) {
            this.fDOMValidatorHandler = this.fDOMResultAugmentor;
            this.fDOMResultAugmentor.setDOMResult(result);
            this.fSchemaValidator.setDocumentHandler(this.fDOMResultAugmentor);
            return;
        }
        if (result.getNode() == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                result.setNode(builder.newDocument());
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e);
            }
        }
        this.fDOMValidatorHandler = this.fDOMResultBuilder;
        this.fDOMResultBuilder.setDOMResult(result);
        this.fSchemaValidator.setDocumentHandler(this.fDOMResultBuilder);
    }

    private void fillQName(QName toFill, Node node) {
        String prefix = node.getPrefix();
        String localName = node.getLocalName();
        String rawName = node.getNodeName();
        String namespace = node.getNamespaceURI();
        toFill.prefix = prefix != null ? this.fSymbolTable.addSymbol(prefix) : XMLSymbols.EMPTY_STRING;
        toFill.localpart = localName != null ? this.fSymbolTable.addSymbol(localName) : XMLSymbols.EMPTY_STRING;
        toFill.rawname = rawName != null ? this.fSymbolTable.addSymbol(rawName) : XMLSymbols.EMPTY_STRING;
        toFill.uri = namespace != null && namespace.length() > 0 ? this.fSymbolTable.addSymbol(namespace) : null;
    }

    private void processAttributes(NamedNodeMap attrMap) {
        int attrCount = attrMap.getLength();
        this.fAttributes.removeAllAttributes();
        int i = 0;
        while (i < attrCount) {
            Attr attr = (Attr)attrMap.item(i);
            String value = attr.getValue();
            if (value == null) {
                value = XMLSymbols.EMPTY_STRING;
            }
            this.fillQName(this.fAttributeQName, attr);
            this.fAttributes.addAttributeNS(this.fAttributeQName, XMLSymbols.fCDATASymbol, value);
            this.fAttributes.setSpecified(i, attr.getSpecified());
            if (this.fAttributeQName.uri == NamespaceContext.XMLNS_URI) {
                if (this.fAttributeQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                    this.fNamespaceContext.declarePrefix(this.fAttributeQName.localpart, value.length() != 0 ? this.fSymbolTable.addSymbol(value) : null);
                } else {
                    this.fNamespaceContext.declarePrefix(XMLSymbols.EMPTY_STRING, value.length() != 0 ? this.fSymbolTable.addSymbol(value) : null);
                }
            }
            ++i;
        }
    }

    private void sendCharactersToValidator(String str) {
        if (str != null) {
            int length = str.length();
            int remainder = length & 0x3FF;
            if (remainder > 0) {
                str.getChars(0, remainder, this.fCharBuffer, 0);
                this.fTempString.setValues(this.fCharBuffer, 0, remainder);
                this.fSchemaValidator.characters(this.fTempString, null);
            }
            int i = remainder;
            while (i < length) {
                str.getChars(i, i += 1024, this.fCharBuffer, 0);
                this.fTempString.setValues(this.fCharBuffer, 0, 1024);
                this.fSchemaValidator.characters(this.fTempString, null);
            }
        }
    }

    private boolean useIsSameNode(Node node) {
        Document doc;
        if (node instanceof NodeImpl) {
            return false;
        }
        Document document = doc = node.getNodeType() == 9 ? (Document)node : node.getOwnerDocument();
        return doc != null && doc.getImplementation().hasFeature("Core", "3.0");
    }

    Node getCurrentElement() {
        return this.fCurrentElement;
    }

    final class DOMNamespaceContext
    implements NamespaceContext {
        protected String[] fNamespace = new String[32];
        protected int fNamespaceSize = 0;
        protected boolean fDOMContextBuilt = false;

        DOMNamespaceContext() {
        }

        @Override
        public void pushContext() {
            DOMValidatorHelper.this.fNamespaceContext.pushContext();
        }

        @Override
        public void popContext() {
            DOMValidatorHelper.this.fNamespaceContext.popContext();
        }

        @Override
        public boolean declarePrefix(String prefix, String uri) {
            return DOMValidatorHelper.this.fNamespaceContext.declarePrefix(prefix, uri);
        }

        @Override
        public String getURI(String prefix) {
            String uri = DOMValidatorHelper.this.fNamespaceContext.getURI(prefix);
            if (uri == null) {
                if (!this.fDOMContextBuilt) {
                    this.fillNamespaceContext();
                    this.fDOMContextBuilt = true;
                }
                if (this.fNamespaceSize > 0 && !DOMValidatorHelper.this.fNamespaceContext.containsPrefix(prefix)) {
                    uri = this.getURI0(prefix);
                }
            }
            return uri;
        }

        @Override
        public String getPrefix(String uri) {
            return DOMValidatorHelper.this.fNamespaceContext.getPrefix(uri);
        }

        @Override
        public int getDeclaredPrefixCount() {
            return DOMValidatorHelper.this.fNamespaceContext.getDeclaredPrefixCount();
        }

        @Override
        public String getDeclaredPrefixAt(int index) {
            return DOMValidatorHelper.this.fNamespaceContext.getDeclaredPrefixAt(index);
        }

        @Override
        public Enumeration getAllPrefixes() {
            return DOMValidatorHelper.this.fNamespaceContext.getAllPrefixes();
        }

        @Override
        public void reset() {
            this.fDOMContextBuilt = false;
            this.fNamespaceSize = 0;
        }

        private void fillNamespaceContext() {
            if (DOMValidatorHelper.this.fRoot != null) {
                Node currentNode = DOMValidatorHelper.this.fRoot.getParentNode();
                while (currentNode != null) {
                    if (1 == currentNode.getNodeType()) {
                        NamedNodeMap attributes = currentNode.getAttributes();
                        int attrCount = attributes.getLength();
                        int i = 0;
                        while (i < attrCount) {
                            Attr attr = (Attr)attributes.item(i);
                            String value = attr.getValue();
                            if (value == null) {
                                value = XMLSymbols.EMPTY_STRING;
                            }
                            DOMValidatorHelper.this.fillQName(DOMValidatorHelper.this.fAttributeQName, attr);
                            if (DOMValidatorHelper.this.fAttributeQName.uri == NamespaceContext.XMLNS_URI) {
                                if (DOMValidatorHelper.this.fAttributeQName.prefix == XMLSymbols.PREFIX_XMLNS) {
                                    this.declarePrefix0(DOMValidatorHelper.this.fAttributeQName.localpart, value.length() != 0 ? DOMValidatorHelper.this.fSymbolTable.addSymbol(value) : null);
                                } else {
                                    this.declarePrefix0(XMLSymbols.EMPTY_STRING, value.length() != 0 ? DOMValidatorHelper.this.fSymbolTable.addSymbol(value) : null);
                                }
                            }
                            ++i;
                        }
                    }
                    currentNode = currentNode.getParentNode();
                }
            }
        }

        private void declarePrefix0(String prefix, String uri) {
            if (this.fNamespaceSize == this.fNamespace.length) {
                String[] namespacearray = new String[this.fNamespaceSize * 2];
                System.arraycopy(this.fNamespace, 0, namespacearray, 0, this.fNamespaceSize);
                this.fNamespace = namespacearray;
            }
            this.fNamespace[this.fNamespaceSize++] = prefix;
            this.fNamespace[this.fNamespaceSize++] = uri;
        }

        private String getURI0(String prefix) {
            int i = 0;
            while (i < this.fNamespaceSize) {
                if (this.fNamespace[i] == prefix) {
                    return this.fNamespace[i + 1];
                }
                i += 2;
            }
            return null;
        }
    }
}

