/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.jaxp.datatype;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import mf.javax.xml.datatype.DatatypeConstants;
import mf.javax.xml.datatype.Duration;
import mf.javax.xml.datatype.XMLGregorianCalendar;
import mf.org.apache.xerces.jaxp.datatype.SerializedDuration;
import mf.org.apache.xerces.jaxp.datatype.XMLGregorianCalendarImpl;
import mf.org.apache.xerces.util.DatatypeMessageFormatter;

class DurationImpl
extends Duration
implements Serializable {
    private static final long serialVersionUID = -2650025807136350131L;
    private static final DatatypeConstants.Field[] FIELDS = new DatatypeConstants.Field[]{DatatypeConstants.YEARS, DatatypeConstants.MONTHS, DatatypeConstants.DAYS, DatatypeConstants.HOURS, DatatypeConstants.MINUTES, DatatypeConstants.SECONDS};
    private static final BigDecimal ZERO = BigDecimal.valueOf(0L);
    private final int signum;
    private final BigInteger years;
    private final BigInteger months;
    private final BigInteger days;
    private final BigInteger hours;
    private final BigInteger minutes;
    private final BigDecimal seconds;
    private static final XMLGregorianCalendar[] TEST_POINTS = new XMLGregorianCalendar[]{XMLGregorianCalendarImpl.parse("1696-09-01T00:00:00Z"), XMLGregorianCalendarImpl.parse("1697-02-01T00:00:00Z"), XMLGregorianCalendarImpl.parse("1903-03-01T00:00:00Z"), XMLGregorianCalendarImpl.parse("1903-07-01T00:00:00Z")};
    private static final BigDecimal[] FACTORS;

    static {
        BigDecimal[] bigDecimalArray = new BigDecimal[5];
        bigDecimalArray[0] = BigDecimal.valueOf(12L);
        bigDecimalArray[2] = BigDecimal.valueOf(24L);
        bigDecimalArray[3] = BigDecimal.valueOf(60L);
        bigDecimalArray[4] = BigDecimal.valueOf(60L);
        FACTORS = bigDecimalArray;
    }

    @Override
    public int getSign() {
        return this.signum;
    }

    private int calcSignum(boolean isPositive) {
        if (!(this.years != null && this.years.signum() != 0 || this.months != null && this.months.signum() != 0 || this.days != null && this.days.signum() != 0 || this.hours != null && this.hours.signum() != 0 || this.minutes != null && this.minutes.signum() != 0 || this.seconds != null && this.seconds.signum() != 0)) {
            return 0;
        }
        if (isPositive) {
            return 1;
        }
        return -1;
    }

    protected DurationImpl(boolean isPositive, BigInteger years, BigInteger months, BigInteger days, BigInteger hours, BigInteger minutes, BigDecimal seconds) {
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.signum = this.calcSignum(isPositive);
        if (years == null && months == null && days == null && hours == null && minutes == null && seconds == null) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "AllFieldsNull", null));
        }
        DurationImpl.testNonNegative(years, DatatypeConstants.YEARS);
        DurationImpl.testNonNegative(months, DatatypeConstants.MONTHS);
        DurationImpl.testNonNegative(days, DatatypeConstants.DAYS);
        DurationImpl.testNonNegative(hours, DatatypeConstants.HOURS);
        DurationImpl.testNonNegative(minutes, DatatypeConstants.MINUTES);
        DurationImpl.testNonNegative(seconds, DatatypeConstants.SECONDS);
    }

    private static void testNonNegative(BigInteger n, DatatypeConstants.Field f) {
        if (n != null && n.signum() < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "NegativeField", new Object[]{f.toString()}));
        }
    }

    private static void testNonNegative(BigDecimal n, DatatypeConstants.Field f) {
        if (n != null && n.signum() < 0) {
            throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "NegativeField", new Object[]{f.toString()}));
        }
    }

    protected DurationImpl(boolean isPositive, int years, int months, int days, int hours, int minutes, int seconds) {
        this(isPositive, DurationImpl.wrap(years), DurationImpl.wrap(months), DurationImpl.wrap(days), DurationImpl.wrap(hours), DurationImpl.wrap(minutes), seconds != 0 ? BigDecimal.valueOf(seconds) : null);
    }

    private static BigInteger wrap(int i) {
        if (i == Integer.MIN_VALUE) {
            return null;
        }
        return BigInteger.valueOf(i);
    }

    protected DurationImpl(long durationInMilliSeconds) {
        boolean is0x8000000000000000L = false;
        long l = durationInMilliSeconds;
        if (l > 0L) {
            this.signum = 1;
        } else if (l < 0L) {
            this.signum = -1;
            if (l == Long.MIN_VALUE) {
                ++l;
                is0x8000000000000000L = true;
            }
            l *= -1L;
        } else {
            this.signum = 0;
        }
        this.years = null;
        this.months = null;
        this.seconds = BigDecimal.valueOf(l % 60000L + (long)(is0x8000000000000000L ? 1 : 0), 3);
        this.minutes = (l /= 60000L) == 0L ? null : BigInteger.valueOf(l % 60L);
        this.hours = (l /= 60L) == 0L ? null : BigInteger.valueOf(l % 24L);
        this.days = (l /= 24L) == 0L ? null : BigInteger.valueOf(l);
    }

    protected DurationImpl(String lexicalRepresentation) throws IllegalArgumentException {
        boolean positive;
        if (lexicalRepresentation == null) {
            throw new NullPointerException();
        }
        String s = lexicalRepresentation;
        int[] idx = new int[1];
        int length = s.length();
        boolean timeRequired = false;
        idx[0] = 0;
        if (length != idx[0] && s.charAt(idx[0]) == '-') {
            idx[0] = idx[0] + 1;
            positive = false;
        } else {
            positive = true;
        }
        if (length != idx[0]) {
            int n = idx[0];
            idx[0] = n + 1;
            if (s.charAt(n) != 'P') {
                throw new IllegalArgumentException(s);
            }
        }
        int dateLen = 0;
        String[] dateParts = new String[3];
        int[] datePartsIndex = new int[3];
        while (length != idx[0] && DurationImpl.isDigit(s.charAt(idx[0])) && dateLen < 3) {
            datePartsIndex[dateLen] = idx[0];
            dateParts[dateLen++] = DurationImpl.parsePiece(s, idx);
        }
        if (length != idx[0]) {
            int n = idx[0];
            idx[0] = n + 1;
            if (s.charAt(n) == 'T') {
                timeRequired = true;
            } else {
                throw new IllegalArgumentException(s);
            }
        }
        int timeLen = 0;
        String[] timeParts = new String[3];
        int[] timePartsIndex = new int[3];
        while (length != idx[0] && DurationImpl.isDigitOrPeriod(s.charAt(idx[0])) && timeLen < 3) {
            timePartsIndex[timeLen] = idx[0];
            timeParts[timeLen++] = DurationImpl.parsePiece(s, idx);
        }
        if (timeRequired && timeLen == 0) {
            throw new IllegalArgumentException(s);
        }
        if (length != idx[0]) {
            throw new IllegalArgumentException(s);
        }
        if (dateLen == 0 && timeLen == 0) {
            throw new IllegalArgumentException(s);
        }
        DurationImpl.organizeParts(s, dateParts, datePartsIndex, dateLen, "YMD");
        DurationImpl.organizeParts(s, timeParts, timePartsIndex, timeLen, "HMS");
        this.years = DurationImpl.parseBigInteger(s, dateParts[0], datePartsIndex[0]);
        this.months = DurationImpl.parseBigInteger(s, dateParts[1], datePartsIndex[1]);
        this.days = DurationImpl.parseBigInteger(s, dateParts[2], datePartsIndex[2]);
        this.hours = DurationImpl.parseBigInteger(s, timeParts[0], timePartsIndex[0]);
        this.minutes = DurationImpl.parseBigInteger(s, timeParts[1], timePartsIndex[1]);
        this.seconds = DurationImpl.parseBigDecimal(s, timeParts[2], timePartsIndex[2]);
        this.signum = this.calcSignum(positive);
    }

    private static boolean isDigit(char ch) {
        return '0' <= ch && ch <= '9';
    }

    private static boolean isDigitOrPeriod(char ch) {
        return DurationImpl.isDigit(ch) || ch == '.';
    }

    private static String parsePiece(String whole, int[] idx) throws IllegalArgumentException {
        int start = idx[0];
        while (idx[0] < whole.length() && DurationImpl.isDigitOrPeriod(whole.charAt(idx[0]))) {
            idx[0] = idx[0] + 1;
        }
        if (idx[0] == whole.length()) {
            throw new IllegalArgumentException(whole);
        }
        idx[0] = idx[0] + 1;
        return whole.substring(start, idx[0]);
    }

    private static void organizeParts(String whole, String[] parts, int[] partsIndex, int len, String tokens) throws IllegalArgumentException {
        int idx = tokens.length();
        int i = len - 1;
        while (i >= 0) {
            if (parts[i] == null) {
                throw new IllegalArgumentException(whole);
            }
            int nidx = tokens.lastIndexOf(parts[i].charAt(parts[i].length() - 1), idx - 1);
            if (nidx == -1) {
                throw new IllegalArgumentException(whole);
            }
            int j = nidx + 1;
            while (j < idx) {
                parts[j] = null;
                ++j;
            }
            idx = nidx;
            parts[idx] = parts[i];
            partsIndex[idx] = partsIndex[i];
            --i;
        }
        --idx;
        while (idx >= 0) {
            parts[idx] = null;
            --idx;
        }
    }

    private static BigInteger parseBigInteger(String whole, String part, int index) throws IllegalArgumentException {
        if (part == null) {
            return null;
        }
        part = part.substring(0, part.length() - 1);
        return new BigInteger(part);
    }

    private static BigDecimal parseBigDecimal(String whole, String part, int index) throws IllegalArgumentException {
        if (part == null) {
            return null;
        }
        part = part.substring(0, part.length() - 1);
        return new BigDecimal(part);
    }

    @Override
    public int compare(Duration rhs) {
        BigInteger maxintAsBigInteger = BigInteger.valueOf(Integer.MAX_VALUE);
        if (this.years != null && this.years.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.YEARS.toString(), this.years.toString()}));
        }
        if (this.months != null && this.months.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.MONTHS.toString(), this.months.toString()}));
        }
        if (this.days != null && this.days.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.DAYS.toString(), this.days.toString()}));
        }
        if (this.hours != null && this.hours.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.HOURS.toString(), this.hours.toString()}));
        }
        if (this.minutes != null && this.minutes.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.MINUTES.toString(), this.minutes.toString()}));
        }
        if (this.seconds != null && this.seconds.toBigInteger().compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.SECONDS.toString(), this.toString(this.seconds)}));
        }
        BigInteger rhsYears = (BigInteger)rhs.getField(DatatypeConstants.YEARS);
        if (rhsYears != null && rhsYears.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.YEARS.toString(), rhsYears.toString()}));
        }
        BigInteger rhsMonths = (BigInteger)rhs.getField(DatatypeConstants.MONTHS);
        if (rhsMonths != null && rhsMonths.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.MONTHS.toString(), rhsMonths.toString()}));
        }
        BigInteger rhsDays = (BigInteger)rhs.getField(DatatypeConstants.DAYS);
        if (rhsDays != null && rhsDays.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.DAYS.toString(), rhsDays.toString()}));
        }
        BigInteger rhsHours = (BigInteger)rhs.getField(DatatypeConstants.HOURS);
        if (rhsHours != null && rhsHours.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.HOURS.toString(), rhsHours.toString()}));
        }
        BigInteger rhsMinutes = (BigInteger)rhs.getField(DatatypeConstants.MINUTES);
        if (rhsMinutes != null && rhsMinutes.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.MINUTES.toString(), rhsMinutes.toString()}));
        }
        BigDecimal rhsSecondsAsBigDecimal = (BigDecimal)rhs.getField(DatatypeConstants.SECONDS);
        BigInteger rhsSeconds = null;
        if (rhsSecondsAsBigDecimal != null) {
            rhsSeconds = rhsSecondsAsBigDecimal.toBigInteger();
        }
        if (rhsSeconds != null && rhsSeconds.compareTo(maxintAsBigInteger) == 1) {
            throw new UnsupportedOperationException(DatatypeMessageFormatter.formatMessage(null, "TooLarge", new Object[]{String.valueOf(this.getClass().getName()) + "#compare(Duration duration)" + DatatypeConstants.SECONDS.toString(), rhsSeconds.toString()}));
        }
        GregorianCalendar lhsCalendar = new GregorianCalendar(1970, 1, 1, 0, 0, 0);
        lhsCalendar.add(1, this.getYears() * this.getSign());
        lhsCalendar.add(2, this.getMonths() * this.getSign());
        lhsCalendar.add(6, this.getDays() * this.getSign());
        lhsCalendar.add(11, this.getHours() * this.getSign());
        lhsCalendar.add(12, this.getMinutes() * this.getSign());
        lhsCalendar.add(13, this.getSeconds() * this.getSign());
        GregorianCalendar rhsCalendar = new GregorianCalendar(1970, 1, 1, 0, 0, 0);
        rhsCalendar.add(1, rhs.getYears() * rhs.getSign());
        rhsCalendar.add(2, rhs.getMonths() * rhs.getSign());
        rhsCalendar.add(6, rhs.getDays() * rhs.getSign());
        rhsCalendar.add(11, rhs.getHours() * rhs.getSign());
        rhsCalendar.add(12, rhs.getMinutes() * rhs.getSign());
        rhsCalendar.add(13, rhs.getSeconds() * rhs.getSign());
        if (lhsCalendar.equals(rhsCalendar)) {
            return 0;
        }
        return this.compareDates(this, rhs);
    }

    private int compareDates(Duration duration1, Duration duration2) {
        int resultA = 2;
        int resultB = 2;
        XMLGregorianCalendar tempA = (XMLGregorianCalendar)TEST_POINTS[0].clone();
        XMLGregorianCalendar tempB = (XMLGregorianCalendar)TEST_POINTS[0].clone();
        tempA.add(duration1);
        tempB.add(duration2);
        resultA = tempA.compare(tempB);
        if (resultA == 2) {
            return 2;
        }
        tempA = (XMLGregorianCalendar)TEST_POINTS[1].clone();
        tempB = (XMLGregorianCalendar)TEST_POINTS[1].clone();
        tempA.add(duration1);
        tempB.add(duration2);
        resultB = tempA.compare(tempB);
        resultA = this.compareResults(resultA, resultB);
        if (resultA == 2) {
            return 2;
        }
        tempA = (XMLGregorianCalendar)TEST_POINTS[2].clone();
        tempB = (XMLGregorianCalendar)TEST_POINTS[2].clone();
        tempA.add(duration1);
        tempB.add(duration2);
        resultB = tempA.compare(tempB);
        resultA = this.compareResults(resultA, resultB);
        if (resultA == 2) {
            return 2;
        }
        tempA = (XMLGregorianCalendar)TEST_POINTS[3].clone();
        tempB = (XMLGregorianCalendar)TEST_POINTS[3].clone();
        tempA.add(duration1);
        tempB.add(duration2);
        resultB = tempA.compare(tempB);
        resultA = this.compareResults(resultA, resultB);
        return resultA;
    }

    private int compareResults(int resultA, int resultB) {
        if (resultB == 2) {
            return 2;
        }
        if (resultA != resultB) {
            return 2;
        }
        return resultA;
    }

    @Override
    public int hashCode() {
        GregorianCalendar cal = TEST_POINTS[0].toGregorianCalendar();
        this.addTo(cal);
        return (int)DurationImpl.getCalendarTimeInMillis(cal);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.signum < 0) {
            buf.append('-');
        }
        buf.append('P');
        if (this.years != null) {
            buf.append(this.years).append('Y');
        }
        if (this.months != null) {
            buf.append(this.months).append('M');
        }
        if (this.days != null) {
            buf.append(this.days).append('D');
        }
        if (this.hours != null || this.minutes != null || this.seconds != null) {
            buf.append('T');
            if (this.hours != null) {
                buf.append(this.hours).append('H');
            }
            if (this.minutes != null) {
                buf.append(this.minutes).append('M');
            }
            if (this.seconds != null) {
                buf.append(this.toString(this.seconds)).append('S');
            }
        }
        return buf.toString();
    }

    private String toString(BigDecimal bd) {
        StringBuffer buf;
        String intString = bd.unscaledValue().toString();
        int scale = bd.scale();
        if (scale == 0) {
            return intString;
        }
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return "0." + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuffer(intString);
            buf.insert(insertionPoint, '.');
        } else {
            buf = new StringBuffer(3 - insertionPoint + intString.length());
            buf.append("0.");
            int i = 0;
            while (i < -insertionPoint) {
                buf.append('0');
                ++i;
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    @Override
    public boolean isSet(DatatypeConstants.Field field) {
        if (field == null) {
            String methodName = "javax.xml.datatype.Duration#isSet(DatatypeConstants.Field field)";
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "FieldCannotBeNull", new Object[]{methodName}));
        }
        if (field == DatatypeConstants.YEARS) {
            return this.years != null;
        }
        if (field == DatatypeConstants.MONTHS) {
            return this.months != null;
        }
        if (field == DatatypeConstants.DAYS) {
            return this.days != null;
        }
        if (field == DatatypeConstants.HOURS) {
            return this.hours != null;
        }
        if (field == DatatypeConstants.MINUTES) {
            return this.minutes != null;
        }
        if (field == DatatypeConstants.SECONDS) {
            return this.seconds != null;
        }
        String methodName = "javax.xml.datatype.Duration#isSet(DatatypeConstants.Field field)";
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "UnknownField", new Object[]{methodName, field.toString()}));
    }

    @Override
    public Number getField(DatatypeConstants.Field field) {
        if (field == null) {
            String methodName = "javax.xml.datatype.Duration#isSet(DatatypeConstants.Field field) ";
            throw new NullPointerException(DatatypeMessageFormatter.formatMessage(null, "FieldCannotBeNull", new Object[]{methodName}));
        }
        if (field == DatatypeConstants.YEARS) {
            return this.years;
        }
        if (field == DatatypeConstants.MONTHS) {
            return this.months;
        }
        if (field == DatatypeConstants.DAYS) {
            return this.days;
        }
        if (field == DatatypeConstants.HOURS) {
            return this.hours;
        }
        if (field == DatatypeConstants.MINUTES) {
            return this.minutes;
        }
        if (field == DatatypeConstants.SECONDS) {
            return this.seconds;
        }
        String methodName = "javax.xml.datatype.Duration#(getSet(DatatypeConstants.Field field)";
        throw new IllegalArgumentException(DatatypeMessageFormatter.formatMessage(null, "UnknownField", new Object[]{methodName, field.toString()}));
    }

    @Override
    public int getYears() {
        return this.getInt(DatatypeConstants.YEARS);
    }

    @Override
    public int getMonths() {
        return this.getInt(DatatypeConstants.MONTHS);
    }

    @Override
    public int getDays() {
        return this.getInt(DatatypeConstants.DAYS);
    }

    @Override
    public int getHours() {
        return this.getInt(DatatypeConstants.HOURS);
    }

    @Override
    public int getMinutes() {
        return this.getInt(DatatypeConstants.MINUTES);
    }

    @Override
    public int getSeconds() {
        return this.getInt(DatatypeConstants.SECONDS);
    }

    private int getInt(DatatypeConstants.Field field) {
        Number n = this.getField(field);
        if (n == null) {
            return 0;
        }
        return n.intValue();
    }

    @Override
    public long getTimeInMillis(Calendar startInstant) {
        Calendar cal = (Calendar)startInstant.clone();
        this.addTo(cal);
        return DurationImpl.getCalendarTimeInMillis(cal) - DurationImpl.getCalendarTimeInMillis(startInstant);
    }

    @Override
    public long getTimeInMillis(Date startInstant) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startInstant);
        this.addTo(cal);
        return DurationImpl.getCalendarTimeInMillis(cal) - startInstant.getTime();
    }

    @Override
    public Duration normalizeWith(Calendar startTimeInstant) {
        Calendar c = (Calendar)startTimeInstant.clone();
        c.add(1, this.getYears() * this.signum);
        c.add(2, this.getMonths() * this.signum);
        c.add(5, this.getDays() * this.signum);
        long diff = DurationImpl.getCalendarTimeInMillis(c) - DurationImpl.getCalendarTimeInMillis(startTimeInstant);
        int days = (int)(diff / 86400000L);
        return new DurationImpl(days >= 0, null, null, DurationImpl.wrap(Math.abs(days)), (BigInteger)this.getField(DatatypeConstants.HOURS), (BigInteger)this.getField(DatatypeConstants.MINUTES), (BigDecimal)this.getField(DatatypeConstants.SECONDS));
    }

    @Override
    public Duration multiply(int factor) {
        return this.multiply(BigDecimal.valueOf(factor));
    }

    @Override
    public Duration multiply(BigDecimal factor) {
        BigDecimal carry = ZERO;
        int factorSign = factor.signum();
        factor = factor.abs();
        BigDecimal[] buf = new BigDecimal[6];
        int i = 0;
        while (i < 5) {
            BigDecimal bd = this.getFieldAsBigDecimal(FIELDS[i]);
            bd = bd.multiply(factor).add(carry);
            buf[i] = bd.setScale(0, 1);
            bd = bd.subtract(buf[i]);
            if (i == 1) {
                if (bd.signum() != 0) {
                    throw new IllegalStateException();
                }
                carry = ZERO;
            } else {
                carry = bd.multiply(FACTORS[i]);
            }
            ++i;
        }
        buf[5] = this.seconds != null ? this.seconds.multiply(factor).add(carry) : carry;
        return new DurationImpl(this.signum * factorSign >= 0, DurationImpl.toBigInteger(buf[0], this.years == null), DurationImpl.toBigInteger(buf[1], this.months == null), DurationImpl.toBigInteger(buf[2], this.days == null), DurationImpl.toBigInteger(buf[3], this.hours == null), DurationImpl.toBigInteger(buf[4], this.minutes == null), (BigDecimal)(buf[5].signum() == 0 && this.seconds == null ? null : buf[5]));
    }

    private BigDecimal getFieldAsBigDecimal(DatatypeConstants.Field f) {
        if (f == DatatypeConstants.SECONDS) {
            if (this.seconds != null) {
                return this.seconds;
            }
            return ZERO;
        }
        BigInteger bi = (BigInteger)this.getField(f);
        if (bi == null) {
            return ZERO;
        }
        return new BigDecimal(bi);
    }

    private static BigInteger toBigInteger(BigDecimal value, boolean canBeNull) {
        if (canBeNull && value.signum() == 0) {
            return null;
        }
        return value.unscaledValue();
    }

    @Override
    public Duration add(Duration rhs) {
        DurationImpl lhs = this;
        BigDecimal[] buf = new BigDecimal[]{DurationImpl.sanitize((BigInteger)((Duration)lhs).getField(DatatypeConstants.YEARS), ((Duration)lhs).getSign()).add(DurationImpl.sanitize((BigInteger)rhs.getField(DatatypeConstants.YEARS), rhs.getSign())), DurationImpl.sanitize((BigInteger)((Duration)lhs).getField(DatatypeConstants.MONTHS), ((Duration)lhs).getSign()).add(DurationImpl.sanitize((BigInteger)rhs.getField(DatatypeConstants.MONTHS), rhs.getSign())), DurationImpl.sanitize((BigInteger)((Duration)lhs).getField(DatatypeConstants.DAYS), ((Duration)lhs).getSign()).add(DurationImpl.sanitize((BigInteger)rhs.getField(DatatypeConstants.DAYS), rhs.getSign())), DurationImpl.sanitize((BigInteger)((Duration)lhs).getField(DatatypeConstants.HOURS), ((Duration)lhs).getSign()).add(DurationImpl.sanitize((BigInteger)rhs.getField(DatatypeConstants.HOURS), rhs.getSign())), DurationImpl.sanitize((BigInteger)((Duration)lhs).getField(DatatypeConstants.MINUTES), ((Duration)lhs).getSign()).add(DurationImpl.sanitize((BigInteger)rhs.getField(DatatypeConstants.MINUTES), rhs.getSign())), DurationImpl.sanitize((BigDecimal)((Duration)lhs).getField(DatatypeConstants.SECONDS), ((Duration)lhs).getSign()).add(DurationImpl.sanitize((BigDecimal)rhs.getField(DatatypeConstants.SECONDS), rhs.getSign()))};
        DurationImpl.alignSigns(buf, 0, 2);
        DurationImpl.alignSigns(buf, 2, 6);
        int s = 0;
        int i = 0;
        while (i < 6) {
            if (s * buf[i].signum() < 0) {
                throw new IllegalStateException();
            }
            if (s == 0) {
                s = buf[i].signum();
            }
            ++i;
        }
        return new DurationImpl(s >= 0, DurationImpl.toBigInteger(DurationImpl.sanitize(buf[0], s), ((Duration)lhs).getField(DatatypeConstants.YEARS) == null && rhs.getField(DatatypeConstants.YEARS) == null), DurationImpl.toBigInteger(DurationImpl.sanitize(buf[1], s), ((Duration)lhs).getField(DatatypeConstants.MONTHS) == null && rhs.getField(DatatypeConstants.MONTHS) == null), DurationImpl.toBigInteger(DurationImpl.sanitize(buf[2], s), ((Duration)lhs).getField(DatatypeConstants.DAYS) == null && rhs.getField(DatatypeConstants.DAYS) == null), DurationImpl.toBigInteger(DurationImpl.sanitize(buf[3], s), ((Duration)lhs).getField(DatatypeConstants.HOURS) == null && rhs.getField(DatatypeConstants.HOURS) == null), DurationImpl.toBigInteger(DurationImpl.sanitize(buf[4], s), ((Duration)lhs).getField(DatatypeConstants.MINUTES) == null && rhs.getField(DatatypeConstants.MINUTES) == null), (BigDecimal)(buf[5].signum() == 0 && ((Duration)lhs).getField(DatatypeConstants.SECONDS) == null && rhs.getField(DatatypeConstants.SECONDS) == null ? null : DurationImpl.sanitize(buf[5], s)));
    }

    private static void alignSigns(BigDecimal[] buf, int start, int end) {
        boolean touched;
        do {
            touched = false;
            int s = 0;
            int i = start;
            while (i < end) {
                if (s * buf[i].signum() < 0) {
                    touched = true;
                    BigDecimal borrow = buf[i].abs().divide(FACTORS[i - 1], 0);
                    if (buf[i].signum() > 0) {
                        borrow = borrow.negate();
                    }
                    buf[i - 1] = buf[i - 1].subtract(borrow);
                    buf[i] = buf[i].add(borrow.multiply(FACTORS[i - 1]));
                }
                if (buf[i].signum() != 0) {
                    s = buf[i].signum();
                }
                ++i;
            }
        } while (touched);
    }

    private static BigDecimal sanitize(BigInteger value, int signum) {
        if (signum == 0 || value == null) {
            return ZERO;
        }
        if (signum > 0) {
            return new BigDecimal(value);
        }
        return new BigDecimal(value.negate());
    }

    static BigDecimal sanitize(BigDecimal value, int signum) {
        if (signum == 0 || value == null) {
            return ZERO;
        }
        if (signum > 0) {
            return value;
        }
        return value.negate();
    }

    @Override
    public Duration subtract(Duration rhs) {
        return this.add(rhs.negate());
    }

    @Override
    public Duration negate() {
        return new DurationImpl(this.signum <= 0, this.years, this.months, this.days, this.hours, this.minutes, this.seconds);
    }

    public int signum() {
        return this.signum;
    }

    @Override
    public void addTo(Calendar calendar) {
        calendar.add(1, this.getYears() * this.signum);
        calendar.add(2, this.getMonths() * this.signum);
        calendar.add(5, this.getDays() * this.signum);
        calendar.add(10, this.getHours() * this.signum);
        calendar.add(12, this.getMinutes() * this.signum);
        calendar.add(13, this.getSeconds() * this.signum);
        if (this.seconds != null) {
            BigDecimal fraction = this.seconds.subtract(this.seconds.setScale(0, 1));
            int millisec = fraction.movePointRight(3).intValue();
            calendar.add(14, millisec * this.signum);
        }
    }

    @Override
    public void addTo(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.addTo(cal);
        date.setTime(DurationImpl.getCalendarTimeInMillis(cal));
    }

    private static long getCalendarTimeInMillis(Calendar cal) {
        return cal.getTime().getTime();
    }

    private Object writeReplace() throws IOException {
        return new SerializedDuration(this.toString());
    }
}

