/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.dv.xs;

import mf.org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import mf.org.apache.xerces.impl.dv.ValidationContext;
import mf.org.apache.xerces.impl.dv.util.Base64;
import mf.org.apache.xerces.impl.dv.util.ByteListImpl;
import mf.org.apache.xerces.impl.dv.xs.TypeValidator;

public class Base64BinaryDV
extends TypeValidator {
    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        byte[] decoded = Base64.decode(content);
        if (decoded == null) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "base64Binary"});
        }
        return new XBase64(decoded);
    }

    @Override
    public int getDataLength(Object value) {
        return ((XBase64)value).getLength();
    }

    private static final class XBase64
    extends ByteListImpl {
        public XBase64(byte[] data) {
            super(data);
        }

        @Override
        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = Base64.encode(this.data);
            }
            return this.canonical;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof XBase64)) {
                return false;
            }
            int len = this.data.length;
            byte[] odata = ((XBase64)obj).data;
            if (len != odata.length) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (this.data[i] != odata[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.data.length) {
                hash = hash * 37 + (this.data[i] & 0xFF);
                ++i;
            }
            return hash;
        }
    }
}

