/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.dv.util;

public final class HexBin {
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 16;
    private static final byte[] hexNumberTable = new byte[128];
    private static final char[] lookUpHexAlphabet = new char[16];

    static {
        int i = 0;
        while (i < 128) {
            HexBin.hexNumberTable[i] = -1;
            ++i;
        }
        i = 57;
        while (i >= 48) {
            HexBin.hexNumberTable[i] = (byte)(i - 48);
            --i;
        }
        i = 70;
        while (i >= 65) {
            HexBin.hexNumberTable[i] = (byte)(i - 65 + 10);
            --i;
        }
        i = 102;
        while (i >= 97) {
            HexBin.hexNumberTable[i] = (byte)(i - 97 + 10);
            --i;
        }
        i = 0;
        while (i < 10) {
            HexBin.lookUpHexAlphabet[i] = (char)(48 + i);
            ++i;
        }
        i = 10;
        while (i <= 15) {
            HexBin.lookUpHexAlphabet[i] = (char)(65 + i - 10);
            ++i;
        }
    }

    public static String encode(byte[] binaryData) {
        if (binaryData == null) {
            return null;
        }
        int lengthData = binaryData.length;
        int lengthEncode = lengthData * 2;
        char[] encodedData = new char[lengthEncode];
        int i = 0;
        while (i < lengthData) {
            int temp = binaryData[i];
            if (temp < 0) {
                temp += 256;
            }
            encodedData[i * 2] = lookUpHexAlphabet[temp >> 4];
            encodedData[i * 2 + 1] = lookUpHexAlphabet[temp & 0xF];
            ++i;
        }
        return new String(encodedData);
    }

    public static byte[] decode(String encoded) {
        if (encoded == null) {
            return null;
        }
        int lengthData = encoded.length();
        if (lengthData % 2 != 0) {
            return null;
        }
        char[] binaryData = encoded.toCharArray();
        int lengthDecode = lengthData / 2;
        byte[] decodedData = new byte[lengthDecode];
        int i = 0;
        while (i < lengthDecode) {
            int temp2;
            int temp1;
            char tempChar = binaryData[i * 2];
            int n = temp1 = tempChar < '\u0080' ? hexNumberTable[tempChar] : -1;
            if (temp1 == -1) {
                return null;
            }
            tempChar = binaryData[i * 2 + 1];
            int n2 = temp2 = tempChar < '\u0080' ? hexNumberTable[tempChar] : -1;
            if (temp2 == -1) {
                return null;
            }
            decodedData[i] = (byte)(temp1 << 4 | temp2);
            ++i;
        }
        return decodedData;
    }
}

