/*
 * Decompiled with CFR 0.152.
 */
package mf.javax.xml.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import mf.javax.xml.validation.SchemaFactory;
import mf.javax.xml.validation.SecuritySupport;

class SchemaFactoryFinder {
    private static boolean debug = false;
    private static SecuritySupport ss = new SecuritySupport();
    private static Properties cacheProps = new Properties();
    private static volatile boolean firstTime = true;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception _) {
            debug = false;
        }
        SERVICE_CLASS = SchemaFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static void debugPrintln(String msg) {
        if (debug) {
            System.err.println("JAXP: " + msg);
        }
    }

    public SchemaFactoryFinder(ClassLoader loader) {
        this.classLoader = loader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == ss.getContextClassLoader()) {
                SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public SchemaFactory newFactory(String schemaLanguage) {
        if (schemaLanguage == null) {
            throw new NullPointerException();
        }
        SchemaFactory f = this._newFactory(schemaLanguage);
        if (f != null) {
            SchemaFactoryFinder.debugPrintln("factory '" + f.getClass().getName() + "' was found for " + schemaLanguage);
        } else {
            SchemaFactoryFinder.debugPrintln("unable to find a factory for " + schemaLanguage);
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaFactory _newFactory(String schemaLanguage) {
        SchemaFactory sf;
        block19: {
            String propertyName;
            block18: {
                propertyName = String.valueOf(SERVICE_CLASS.getName()) + ":" + schemaLanguage;
                try {
                    SchemaFactoryFinder.debugPrintln("Looking up system property '" + propertyName + "'");
                    String r = ss.getSystemProperty(propertyName);
                    if (r != null) {
                        SchemaFactoryFinder.debugPrintln("The value is '" + r + "'");
                        sf = this.createInstance(r, true);
                        if (sf != null) {
                            return sf;
                        }
                    } else {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable t) {
                    if (!debug) break block18;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + propertyName + "'");
                    t.printStackTrace();
                }
            }
            String javah = ss.getSystemProperty("java.home");
            String configFile = String.valueOf(javah) + File.separator + "lib" + File.separator + "jaxp.properties";
            String factoryClassName = null;
            try {
                if (firstTime) {
                    Properties properties = cacheProps;
                    synchronized (properties) {
                        if (firstTime) {
                            File f = new File(configFile);
                            firstTime = false;
                            if (ss.doesFileExist(f)) {
                                SchemaFactoryFinder.debugPrintln("Read properties file " + f);
                                cacheProps.load(ss.getFileInputStream(f));
                            }
                        }
                    }
                }
                factoryClassName = cacheProps.getProperty(propertyName);
                SchemaFactoryFinder.debugPrintln("found " + factoryClassName + " in $java.home/jaxp.properties");
                if (factoryClassName != null && (sf = this.createInstance(factoryClassName, true)) != null) {
                    return sf;
                }
            }
            catch (Exception ex) {
                if (!debug) break block19;
                ex.printStackTrace();
            }
        }
        Iterator sitr = this.createServiceFileIterator();
        while (sitr.hasNext()) {
            URL resource = (URL)sitr.next();
            SchemaFactoryFinder.debugPrintln("looking into " + resource);
            try {
                sf = this.loadFromService(schemaLanguage, resource.toExternalForm(), ss.getURLInputStream(resource));
                if (sf == null) continue;
                return sf;
            }
            catch (IOException e) {
                if (!debug) continue;
                SchemaFactoryFinder.debugPrintln("failed to read " + resource);
                e.printStackTrace();
            }
        }
        if (schemaLanguage.equals("http://www.w3.org/2001/XMLSchema")) {
            SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema validator");
            return this.createInstance("com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", true);
        }
        SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private Class createClass(String className) {
        Class<?> clazz;
        try {
            clazz = this.classLoader != null ? this.classLoader.loadClass(className) : Class.forName(className);
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            return null;
        }
        return clazz;
    }

    SchemaFactory createInstance(String className) {
        return this.createInstance(className, false);
    }

    SchemaFactory createInstance(String className, boolean useServicesMechanism) {
        SchemaFactory schemaFactory = null;
        SchemaFactoryFinder.debugPrintln("createInstance(" + className + ")");
        Class clazz = this.createClass(className);
        if (clazz == null) {
            SchemaFactoryFinder.debugPrintln("failed to getClass(" + className + ")");
            return null;
        }
        SchemaFactoryFinder.debugPrintln("loaded " + className + " from " + SchemaFactoryFinder.which(clazz));
        try {
            if (!useServicesMechanism) {
                schemaFactory = (SchemaFactory)SchemaFactoryFinder.newInstanceNoServiceLoader(clazz);
            }
            if (schemaFactory == null) {
                schemaFactory = (SchemaFactory)clazz.newInstance();
            }
        }
        catch (ClassCastException classCastException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                classCastException.printStackTrace();
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                instantiationException.printStackTrace();
            }
            return null;
        }
        return schemaFactory;
    }

    private static Object newInstanceNoServiceLoader(Class<?> providerClass) {
        if (System.getSecurityManager() == null) {
            return null;
        }
        try {
            Method creationMethod = providerClass.getDeclaredMethod("newXMLSchemaFactoryNoServiceLoader", new Class[0]);
            return creationMethod.invoke(null, null);
        }
        catch (NoSuchMethodException exc) {
            return null;
        }
        catch (Exception exc) {
            return null;
        }
    }

    private SchemaFactory loadFromProperty(String keyName, String resourceName, InputStream in) throws IOException {
        SchemaFactoryFinder.debugPrintln("Reading " + resourceName);
        Properties props = new Properties();
        props.load(in);
        in.close();
        String factoryClassName = props.getProperty(keyName);
        if (factoryClassName != null) {
            SchemaFactoryFinder.debugPrintln("found " + keyName + " = " + factoryClassName);
            return this.createInstance(factoryClassName);
        }
        SchemaFactoryFinder.debugPrintln(String.valueOf(keyName) + " is not in the property file");
        return null;
    }

    private SchemaFactory loadFromService(String schemaLanguage, String inputName, InputStream in) throws IOException {
        SchemaFactory schemaFactory = null;
        Class[] stringClassArray = new Class[]{"".getClass()};
        Object[] schemaLanguageObjectArray = new Object[]{schemaLanguage};
        String isSchemaLanguageSupportedMethod = "isSchemaLanguageSupported";
        SchemaFactoryFinder.debugPrintln("Reading " + inputName);
        BufferedReader configFile = new BufferedReader(new InputStreamReader(in));
        String line = null;
        while ((line = configFile.readLine()) != null) {
            Class clazz;
            int comment = line.indexOf("#");
            switch (comment) {
                case -1: {
                    break;
                }
                case 0: {
                    line = "";
                    break;
                }
                default: {
                    line = line.substring(0, comment);
                }
            }
            line = line.trim();
            if (line.length() == 0 || (clazz = this.createClass(line)) == null) continue;
            try {
                schemaFactory = (SchemaFactory)clazz.newInstance();
            }
            catch (ClassCastException classCastExcpetion) {
                schemaFactory = null;
                continue;
            }
            catch (InstantiationException instantiationException) {
                schemaFactory = null;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                schemaFactory = null;
                continue;
            }
            try {
                Method isSchemaLanguageSupported = clazz.getMethod("isSchemaLanguageSupported", stringClassArray);
                Boolean supported = (Boolean)isSchemaLanguageSupported.invoke((Object)schemaFactory, schemaLanguageObjectArray);
                if (supported.booleanValue()) {
                    break;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            schemaFactory = null;
        }
        configFile.close();
        return schemaFactory;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){

                @Override
                protected Object value() {
                    ClassLoader classLoader = SchemaFactoryFinder.class.getClassLoader();
                    return ss.getResourceAsURL(classLoader, SERVICE_ID);
                }
            };
        }
        try {
            final Enumeration e = ss.getResources(this.classLoader, SERVICE_ID);
            if (!e.hasMoreElements()) {
                SchemaFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return e.hasMoreElements();
                }

                public Object next() {
                    return e.nextElement();
                }
            };
        }
        catch (IOException e) {
            SchemaFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
            if (debug) {
                e.printStackTrace();
            }
            return new ArrayList().iterator();
        }
    }

    private static String which(Class clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String classname, ClassLoader loader) {
        URL it;
        String classnameAsResource = String.valueOf(classname.replace('.', '/')) + ".class";
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if ((it = ss.getResourceAsURL(loader, classnameAsResource)) != null) {
            return it.toString();
        }
        return null;
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

