package br.com.edsilfer.kotlin_support.service.communication

import java.io.ByteArrayInputStream
import java.io.IOException
import java.io.InputStream
import java.io.OutputStream
import javax.activation.DataSource

/**
 * Created by efernandes on 06/12/16.
 */

class ByteArrayDataSource(data: ByteArray, type: String) : DataSource {
    private var data: ByteArray? = data
    private var type: String? = type

    override fun getContentType(): String {
        if (type == null)
            return EmailManager.ARG_CONTENT_TYPE
        else
            return type!!
    }

    @Throws(IOException::class)
    override fun getInputStream(): InputStream {
        return ByteArrayInputStream(data)
    }

    override fun getName(): String {
        return EmailManager.ARG_NAME
    }

    @Throws(IOException::class)
    override fun getOutputStream(): OutputStream {
        throw IOException("Not Supported")
    }
}
