package br.com.edsilfer.kotlin_support.service

import android.Manifest
import android.content.pm.PackageManager
import android.os.Build
import android.support.v4.app.ActivityCompat
import android.support.v7.app.AppCompatActivity
import br.com.edsilfer.kotlin_support.extensions.log

/**
 * Created by User on 06/12/2016.
 */

object PermissionsManager {
    fun isPermissionGranted(activity: AppCompatActivity, permission: String): Boolean {
        if (Build.VERSION.SDK_INT >= 23) {
            if (activity.checkSelfPermission(permission) == PackageManager.PERMISSION_GRANTED) {
                log("Permission is granted")
                return true
            } else {
                log("Permission is revoked")
                ActivityCompat.requestPermissions(activity, arrayOf<String>(permission), 1)
                return false
            }
        } else {
            log("Permission is granted")
            return true
        }
    }
}

