package br.com.edsilfer.kotlin_support.service

import android.util.Log
import br.com.edsilfer.kotlin_support.model.Events
import br.com.edsilfer.kotlin_support.model.ISubscriber

/**
 * Created by User on 03/12/2016.
 */

object NotificationCenter {

    private val mSubscribers = hashMapOf<Events, MutableSet<ISubscriber>>()

    fun notify (event: Events, payload : Any?) {
        val subscribers = mSubscribers[event]

        if (subscribers != null) {
            for (s in subscribers) {
                s.onEventTriggered(event, payload)
            }
        } else {
            Log.i(NotificationCenter::class.simpleName, "There are no subscribers to process the $event.")
        }
    }

    object RegistrationManager {
        fun registerForEvent(event: Events, subscriber: ISubscriber) {
            var subscribers = mSubscribers[event]

            if (subscribers != null) {
                mSubscribers[event]?.add(subscriber)
            } else {
                subscribers = mutableSetOf(subscriber)
                subscribers.add(subscriber)
                mSubscribers[event] = subscribers
            }
        }

        fun unregisterForEvent(event: Events, subscriber: ISubscriber) {
            val subscribers = mSubscribers[event]
            if (subscribers != null) {
                if (subscribers.contains(subscriber)) {
                    subscribers.remove(subscriber)
                } else {
                    Log.e(RegistrationManager::class.simpleName, "Subscribers was not registered for the given event.")
                }
            } else {
                Log.e(RegistrationManager::class.simpleName, "There are no subscribers for the given event.")
            }
        }
    }
}
