package br.com.edsilfer.kotlin_support.model

import java.io.File

/**
 * Created by efernandes on 06/12/16.
 */

class Email(
        val subject: String,
        val body: String,
        val recipients: MutableList<String>,
        val attachments: Array<File> = arrayOf()
) {

    fun addRecipients(recipient: String) {
        recipients.add(recipient)
    }

    fun removeRecipients(recipient: String) {
        recipients.remove(recipient)
    }

    fun getRecipients(): String {
        val rec = StringBuilder()
        var count = 0
        for (r in recipients) {
            if (recipients.size > 1 && count < recipients.size - 1) {
                rec.append("$r, ")
            } else {
                rec.append(r)
            }
            count++
        }
        return rec.toString()
    }
}

data class Sender (val email : String, val password : String)
