package br.com.edsilfer.kotlin_support.extensions

import android.app.Service
import android.text.TextUtils
import android.view.ViewGroup
import android.view.inputmethod.InputMethodManager
import android.widget.TextView
import br.com.edsilfer.android.messenger.service.softkeyboard.SoftKeyboard

fun TextView.slideHorizontal() {
    ellipsize = TextUtils.TruncateAt.MARQUEE
    marqueeRepeatLimit = -1
    isSelected = true
}

fun TextView.addSoftwareKeyboardListener(listener: SoftKeyboard.SoftKeyboardListener) {
    val im = context.getSystemService(Service.INPUT_METHOD_SERVICE) as InputMethodManager
    val softKeyboard = SoftKeyboard(rootView as ViewGroup, im)
    softKeyboard.setSoftKeyboardCallback(listener)
}
