/*
 * Decompiled with CFR 0.152.
 */
package jep;

import java.lang.reflect.Array;
import java.util.Arrays;
import jep.AbstractNDArray;

public class NDArray<T>
extends AbstractNDArray<T> {
    public NDArray(T t) {
        super(t);
    }

    public NDArray(T t, boolean bl) {
        super(t, bl);
    }

    public NDArray(T t, int ... nArray) {
        super(t, nArray);
    }

    public NDArray(T t, boolean bl, int ... nArray) {
        super(t, bl, nArray);
    }

    @Override
    protected void validate(T t) {
        if (!t.getClass().isArray() || !t.getClass().getComponentType().isPrimitive()) {
            throw new IllegalArgumentException("NDArray only supports primitive arrays, received " + t.getClass().getName());
        }
        if (t instanceof char[]) {
            throw new IllegalArgumentException("NDArray only supports numeric primitives, not char[]");
        }
    }

    @Override
    protected int getLength(T t) {
        return Array.getLength(t);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NDArray nDArray = (NDArray)object;
        if (this.unsigned != nDArray.unsigned) {
            return false;
        }
        if (!Arrays.equals(this.dimensions, nDArray.dimensions)) {
            return false;
        }
        if (nDArray.data == null) {
            return false;
        }
        if (!this.data.getClass().equals(nDArray.data.getClass())) {
            return false;
        }
        Class<?> clazz = this.data.getClass().getComponentType();
        if (clazz == Boolean.TYPE) {
            return Arrays.equals((boolean[])this.data, (boolean[])nDArray.data);
        }
        if (clazz == Byte.TYPE) {
            return Arrays.equals((byte[])this.data, (byte[])nDArray.data);
        }
        if (clazz == Short.TYPE) {
            return Arrays.equals((short[])this.data, (short[])nDArray.data);
        }
        if (clazz == Integer.TYPE) {
            return Arrays.equals((int[])this.data, (int[])nDArray.data);
        }
        if (clazz == Long.TYPE) {
            return Arrays.equals((long[])this.data, (long[])nDArray.data);
        }
        if (clazz == Float.TYPE) {
            return Arrays.equals((float[])this.data, (float[])nDArray.data);
        }
        if (clazz == Double.TYPE) {
            return Arrays.equals((double[])this.data, (double[])nDArray.data);
        }
        throw new IllegalStateException("NDArray only supports primitive arrays, received " + clazz.getName());
    }

    public int hashCode() {
        int n = 1;
        if (this.data == null) {
            n = 31 * n + 0;
        } else {
            Class<?> clazz = this.data.getClass().getComponentType();
            if (clazz == Boolean.TYPE) {
                n = 31 * n + Arrays.hashCode((boolean[])this.data);
            } else if (clazz == Byte.TYPE) {
                n = 31 * n + Arrays.hashCode((byte[])this.data);
            } else if (clazz == Short.TYPE) {
                n = 31 * n + Arrays.hashCode((short[])this.data);
            } else if (clazz == Integer.TYPE) {
                n = 31 * n + Arrays.hashCode((int[])this.data);
            } else if (clazz == Long.TYPE) {
                n = 31 * n + Arrays.hashCode((long[])this.data);
            } else if (clazz == Float.TYPE) {
                n = 31 * n + Arrays.hashCode((float[])this.data);
            } else if (clazz == Double.TYPE) {
                n = 31 * n + Arrays.hashCode((double[])this.data);
            } else {
                throw new IllegalStateException("NDArray only supports primitive arrays, received " + clazz.getName());
            }
        }
        n = 31 * n + Arrays.hashCode(this.dimensions) + (this.unsigned ? 1 : 0);
        return n;
    }
}

