/*
 * Decompiled with CFR 0.152.
 */
package jep.python;

import jep.Jep;
import jep.JepException;
import jep.python.PyPointer;

public class PyObject
implements AutoCloseable {
    protected final PyPointer pointer;
    protected final Jep jep;

    public PyObject(long l, long l2, Jep jep) throws JepException {
        this.jep = jep;
        this.pointer = new PyPointer(this, jep, l, l2);
    }

    protected long getPyObject() {
        return this.pointer.pyObject;
    }

    @Deprecated
    public void isValid() throws JepException {
        this.checkValid();
    }

    protected void checkValid() throws JepException {
        this.jep.isValidThread();
        if (this.pointer.isDisposed()) {
            throw new JepException(this.getClass().getSimpleName() + " has been closed.");
        }
    }

    protected void checkValidRuntime() throws IllegalStateException {
        try {
            this.checkValid();
        }
        catch (JepException jepException) {
            throw new IllegalStateException(jepException);
        }
    }

    @Deprecated
    public void decref() throws JepException {
        this.isValid();
        this.decref(this.pointer.tstate, this.pointer.pyObject);
    }

    private native void decref(long var1, long var3) throws JepException;

    @Deprecated
    public void incref() throws JepException {
        this.isValid();
        this.incref(this.pointer.tstate, this.pointer.pyObject);
    }

    private native void incref(long var1, long var3) throws JepException;

    @Override
    public void close() throws JepException {
        this.jep.isValidThread();
        this.pointer.dispose();
    }

    @Deprecated
    public void set(String string, Object object) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, object);
    }

    private native void set(long var1, long var3, String var5, Object var6) throws JepException;

    @Deprecated
    public void set(String string, String string2) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, string2);
    }

    private native void set(long var1, long var3, String var5, String var6) throws JepException;

    @Deprecated
    public void set(String string, boolean bl) throws JepException {
        if (bl) {
            this.set(string, 1);
        } else {
            this.set(string, 0);
        }
    }

    @Deprecated
    public void set(String string, int n) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, n);
    }

    @Deprecated
    public void set(String string, short s) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, s);
    }

    private native void set(long var1, long var3, String var5, int var6) throws JepException;

    @Deprecated
    public void set(String string, char[] cArray) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, new String(cArray));
    }

    @Deprecated
    public void set(String string, char c) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, new String(new char[]{c}));
    }

    @Deprecated
    public void set(String string, byte by) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, by);
    }

    @Deprecated
    public void set(String string, long l) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, l);
    }

    private native void set(long var1, long var3, String var5, long var6) throws JepException;

    @Deprecated
    public void set(String string, double d) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, d);
    }

    private native void set(long var1, long var3, String var5, double var6) throws JepException;

    @Deprecated
    public void set(String string, float f) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, f);
    }

    private native void set(long var1, long var3, String var5, float var6) throws JepException;

    @Deprecated
    public void set(String string, boolean[] blArray) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, blArray);
    }

    private native void set(long var1, long var3, String var5, boolean[] var6) throws JepException;

    @Deprecated
    public void set(String string, int[] nArray) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, nArray);
    }

    private native void set(long var1, long var3, String var5, int[] var6) throws JepException;

    @Deprecated
    public void set(String string, short[] sArray) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, sArray);
    }

    private native void set(long var1, long var3, String var5, short[] var6) throws JepException;

    @Deprecated
    public void set(String string, byte[] byArray) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, byArray);
    }

    private native void set(long var1, long var3, String var5, byte[] var6) throws JepException;

    @Deprecated
    public void set(String string, long[] lArray) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, lArray);
    }

    private native void set(long var1, long var3, String var5, long[] var6) throws JepException;

    @Deprecated
    public void set(String string, double[] dArray) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, dArray);
    }

    private native void set(long var1, long var3, String var5, double[] var6) throws JepException;

    @Deprecated
    public void set(String string, float[] fArray) throws JepException {
        this.isValid();
        this.set(this.pointer.tstate, this.pointer.pyObject, string, fArray);
    }

    private native void set(long var1, long var3, String var5, float[] var6) throws JepException;

    public Object getAttr(String string) throws JepException {
        this.checkValid();
        return this.getAttr(this.pointer.tstate, this.pointer.pyObject, string, Object.class);
    }

    public <T> T getAttr(String string, Class<T> clazz) throws JepException {
        this.checkValid();
        return clazz.cast(this.getAttr(this.pointer.tstate, this.pointer.pyObject, string, clazz));
    }

    private native Object getAttr(long var1, long var3, String var5, Class<?> var6) throws JepException;

    public void setAttr(String string, Object object) throws JepException {
        this.checkValid();
        this.setAttr(this.pointer.tstate, this.pointer.pyObject, string, object);
    }

    private native void setAttr(long var1, long var3, String var5, Object var6);

    public void delAttr(String string) throws JepException {
        this.checkValid();
        this.delAttr(this.pointer.tstate, this.pointer.pyObject, string);
    }

    private native void delAttr(long var1, long var3, String var5);

    protected native long createModule(long var1, long var3, String var5) throws JepException;

    protected native Object getValue(long var1, long var3, String var5) throws JepException;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        this.checkValidRuntime();
        return this.equals(this.pointer.tstate, this.pointer.pyObject, object);
    }

    public String toString() {
        this.checkValidRuntime();
        return this.toString(this.pointer.tstate, this.pointer.pyObject);
    }

    public int hashCode() {
        this.checkValidRuntime();
        Long l = this.hashCode(this.pointer.tstate, this.pointer.pyObject);
        return l.hashCode();
    }

    private native boolean equals(long var1, long var3, Object var5);

    private native String toString(long var1, long var3);

    private native long hashCode(long var1, long var3);
}

