/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.aemmjml.components.impl;

import biz.netcentric.cq.tools.aemmjml.MjmlComponent;
import biz.netcentric.cq.tools.aemmjml.helper.AttributeMapping;
import com.adobe.cq.wcm.core.components.models.Image;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Via;
import org.apache.sling.models.annotations.injectorspecific.Self;

@Model(adaptables={SlingHttpServletRequest.class}, adapters={MjmlImageImpl.class, MjmlComponent.class}, resourceType={"netcentric/aemmjml/core/components/image"})
public class MjmlImageImpl
implements MjmlComponent {
    private final Map<String, String> attributes;

    @Inject
    public MjmlImageImpl(@Self @Via(value="resource") Resource self, @Self Image image) {
        this.attributes = new AttributeMapping(self).with("align", "center").with("border").with("border-radius").with("container-background-color").with("fluid-on-mobile").with("height", "auto").with("padding", "0px").with("padding-top").with("padding-right").with("padding-bottom").with("padding-left").with("width").getAttributes();
        AttributeMapping.putNotBlank(this.attributes, (String)"href", (CharSequence)image.getLink());
        AttributeMapping.putNotBlank(this.attributes, (String)"src", (CharSequence)image.getSrc());
        AttributeMapping.putNotBlank(this.attributes, (String)"title", (CharSequence)image.getTitle());
        AttributeMapping.putNotBlank(this.attributes, (String)"alt", (CharSequence)image.getAlt());
        String srcUriTemplate = image.getSrcUriTemplate();
        if (StringUtils.isNotBlank((CharSequence)srcUriTemplate)) {
            int[] imageWidths = image.getWidths();
            Arrays.sort(imageWidths);
            StringBuilder srcset = new StringBuilder(imageWidths.length * srcUriTemplate.length());
            for (int i = 0; i < imageWidths.length; ++i) {
                srcset.append(srcUriTemplate.replace("{.width}", "." + imageWidths[i]));
                srcset.append(' ');
                srcset.append(imageWidths[i]);
                srcset.append('w');
                if (i + 1 >= imageWidths.length) continue;
                srcset.append(',');
                srcset.append(' ');
            }
            AttributeMapping.putNotBlank(this.attributes, (String)"srcset", (CharSequence)srcset);
        }
    }

    @Nonnull
    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

