/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.authorizableinstaller.impl;

import biz.netcentric.cq.tools.actool.authorizableinstaller.impl.AuthInstallerUserManager;
import biz.netcentric.cq.tools.actool.history.InstallationLogger;
import biz.netcentric.cq.tools.actool.history.impl.PersistableInstallationLogger;
import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuthInstallerUserManagerPrefetchingImpl
implements AuthInstallerUserManager {
    private static final Logger LOG = LoggerFactory.getLogger(AuthInstallerUserManagerPrefetchingImpl.class);
    private final UserManager delegate;
    private final Map<String, Authorizable> authorizableCache = new CaseInsensitiveMap();
    private final Map<String, Set<String>> nonRegularUserMembersByAuthorizableId = new CaseInsensitiveMap();
    private final Map<String, Set<String>> isMemberOfByAuthorizableId = new CaseInsensitiveMap();

    public AuthInstallerUserManagerPrefetchingImpl(UserManager delegate, final ValueFactory valueFactory, InstallationLogger installLog) throws RepositoryException {
        this.delegate = delegate;
        long startPrefetch = System.currentTimeMillis();
        Iterator authorizablesToPrefetchIt = delegate.findAuthorizables(new Query(){

            public <T> void build(QueryBuilder<T> builder) {
                builder.setCondition(builder.or(builder.neq("@jcr:primaryType", valueFactory.createValue("rep:User")), builder.eq("@rep:authorizableId", valueFactory.createValue("anonymous"))));
            }
        });
        while (authorizablesToPrefetchIt.hasNext()) {
            Authorizable auth = (Authorizable)authorizablesToPrefetchIt.next();
            String authId = auth.getID();
            this.authorizableCache.put(authId, auth);
            this.nonRegularUserMembersByAuthorizableId.put(authId, new HashSet());
            this.isMemberOfByAuthorizableId.put(authId, new HashSet());
        }
        installLog.addMessage(LOG, "Prefetched " + this.authorizableCache.size() + " authorizables in " + PersistableInstallationLogger.msHumanReadable(System.currentTimeMillis() - startPrefetch));
        long startPrefetchMemberships = System.currentTimeMillis();
        int membershipCount = 0;
        for (Authorizable authorizable : this.authorizableCache.values()) {
            String authId = authorizable.getID();
            Iterator declaredMemberOf = authorizable.declaredMemberOf();
            while (declaredMemberOf.hasNext()) {
                Group memberOfGroup = (Group)declaredMemberOf.next();
                String memberOfGroupId = memberOfGroup.getID();
                this.isMemberOfByAuthorizableId.get(authId).add(memberOfGroupId);
                if (!this.nonRegularUserMembersByAuthorizableId.containsKey(memberOfGroupId)) {
                    throw new IllegalStateException("Group '" + memberOfGroupId + "' is not returned by query /jcr:root/home//element(*,rep:Authorizable)[(@jcr:primaryType!='rep:User' or @rep:authorizableId='anonymous')] (as internally used by userManager.findAuthorizables()) - most likely there is a corrupt index on your platform.");
                }
                this.nonRegularUserMembersByAuthorizableId.get(memberOfGroupId).add(authId);
                ++membershipCount;
            }
        }
        installLog.addMessage(LOG, "Prefetched " + membershipCount + " memberships in " + PersistableInstallationLogger.msHumanReadable(System.currentTimeMillis() - startPrefetchMemberships));
    }

    @Override
    public Authorizable getAuthorizable(String id) throws RepositoryException {
        Authorizable authorizable = this.authorizableCache.get(id);
        if (authorizable == null) {
            authorizable = this.delegate.getAuthorizable(id);
            this.authorizableCache.put(id, authorizable);
        }
        return authorizable;
    }

    @Override
    public Set<String> getDeclaredIsMemberOf(String id) throws RepositoryException {
        if (this.isMemberOfByAuthorizableId.containsKey(id)) {
            return this.isMemberOfByAuthorizableId.get(id);
        }
        HashSet<String> memberOfSet = new HashSet<String>();
        Iterator memberOfIt = this.getAuthorizable(id).declaredMemberOf();
        while (memberOfIt.hasNext()) {
            Authorizable memberOfGroup = (Authorizable)memberOfIt.next();
            memberOfSet.add(memberOfGroup.getID());
        }
        return memberOfSet;
    }

    @Override
    public Set<String> getDeclaredMembersWithoutRegularUsers(String id) {
        return this.nonRegularUserMembersByAuthorizableId.containsKey(id) ? this.nonRegularUserMembersByAuthorizableId.get(id) : Collections.emptySet();
    }

    public int getCacheSize() {
        return this.authorizableCache.size();
    }

    private void refreshAuthorizableCacheIfNeeded(String id, Authorizable authorizable) {
        if (this.authorizableCache.containsKey(id)) {
            this.authorizableCache.put(id, authorizable);
        }
    }

    @Override
    public void removeAuthorizable(Authorizable authorizable) throws RepositoryException {
        Objects.requireNonNull(authorizable);
        this.authorizableCache.remove(authorizable.getID());
        if (authorizable instanceof Group) {
            Group group = (Group)authorizable;
            this.removeGroupFromCache(group);
        }
        authorizable.remove();
    }

    private void removeGroupFromCache(Group group) throws RepositoryException {
        String groupID = group.getID();
        Iterator membersIt = group.getDeclaredMembers();
        while (membersIt.hasNext()) {
            Authorizable member = (Authorizable)membersIt.next();
            String memberID = member.getID();
            if (!this.isMemberOfByAuthorizableId.containsKey(memberID)) continue;
            this.isMemberOfByAuthorizableId.get(memberID).remove(groupID);
        }
    }

    @Override
    public UserManager getOakUserManager() {
        return this.delegate;
    }

    @Override
    public User createUser(String userID, String password, Principal principal, String intermediatePath) throws RepositoryException {
        User user = this.delegate.createUser(userID, password, principal, intermediatePath);
        this.refreshAuthorizableCacheIfNeeded(userID, (Authorizable)user);
        return user;
    }

    @Override
    public User createSystemUser(String userID, String intermediatePath) throws RepositoryException {
        User user = this.delegate.createSystemUser(userID, intermediatePath);
        this.refreshAuthorizableCacheIfNeeded(userID, (Authorizable)user);
        return user;
    }

    @Override
    public Group createGroup(Principal principal) throws RepositoryException {
        Group group = this.delegate.createGroup(principal);
        this.refreshAuthorizableCacheIfNeeded(principal.getName(), (Authorizable)group);
        return group;
    }

    @Override
    public Group createGroup(Principal principal, String intermediatePath) throws RepositoryException {
        Group group = this.delegate.createGroup(principal, intermediatePath);
        this.refreshAuthorizableCacheIfNeeded(principal.getName(), (Authorizable)group);
        return group;
    }
}

