/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.validators;

import biz.netcentric.cq.tools.actool.configmodel.AcConfiguration;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizableConfigBean;
import biz.netcentric.cq.tools.actool.configmodel.AuthorizablesConfig;
import java.util.regex.Pattern;

public class UnmangedExternalMemberRelationshipChecker {
    public static void validate(AcConfiguration acConfiguration) {
        AuthorizablesConfig authorizablesConfig = acConfiguration.getAuthorizablesConfig();
        for (AuthorizableConfigBean authorizableConfigBean : authorizablesConfig) {
            UnmangedExternalMemberRelationshipChecker.checkIsMemberOf(acConfiguration, authorizablesConfig, authorizableConfigBean);
            UnmangedExternalMemberRelationshipChecker.checkMembers(acConfiguration, authorizablesConfig, authorizableConfigBean);
        }
    }

    private static void checkIsMemberOf(AcConfiguration acConfiguration, AuthorizablesConfig authorizablesConfig, AuthorizableConfigBean authorizableConfigBean) {
        String[] isMemberOfArr;
        Pattern unmanagedExternalIsMemberOfRegex = authorizableConfigBean.getUnmanagedExternalIsMemberOfRegex();
        if (unmanagedExternalIsMemberOfRegex == null) {
            unmanagedExternalIsMemberOfRegex = acConfiguration.getGlobalConfiguration().getDefaultUnmanagedExternalIsMemberOfRegex();
        }
        if (unmanagedExternalIsMemberOfRegex != null && (isMemberOfArr = authorizableConfigBean.getIsMemberOf()) != null) {
            for (String isMemberOfId : isMemberOfArr) {
                if (authorizablesConfig.getAuthorizableConfig(isMemberOfId) != null || !unmanagedExternalIsMemberOfRegex.matcher(isMemberOfId).matches()) continue;
                throw new IllegalArgumentException("Group '" + authorizableConfigBean.getAuthorizableId() + "' references external group '" + isMemberOfId + "' via isMemberOf but relationships to this external group is explicitly unmanged by regex " + unmanagedExternalIsMemberOfRegex);
            }
        }
    }

    private static void checkMembers(AcConfiguration acConfiguration, AuthorizablesConfig authorizablesConfig, AuthorizableConfigBean authorizableConfigBean) {
        String[] membersArr;
        Pattern unmanagedExternalMembersRegex = authorizableConfigBean.getUnmanagedExternalMembersRegex();
        if (unmanagedExternalMembersRegex == null) {
            unmanagedExternalMembersRegex = acConfiguration.getGlobalConfiguration().getDefaultUnmanagedExternalMembersRegex();
        }
        if (unmanagedExternalMembersRegex != null && (membersArr = authorizableConfigBean.getMembers()) != null) {
            for (String memberId : membersArr) {
                if (authorizablesConfig.getAuthorizableConfig(memberId) != null || !unmanagedExternalMembersRegex.matcher(memberId).matches()) continue;
                throw new IllegalArgumentException("Group '" + authorizableConfigBean.getAuthorizableId() + "' references external group group or user '" + memberId + "' via members but relationships to this external group is explicitly unmanged by regex " + unmanagedExternalMembersRegex);
            }
        }
    }
}

