/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.impl;

import biz.netcentric.cq.tools.actool.helper.runtime.RuntimeHelper;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={AcConfigChangeTracker.class})
public class AcConfigChangeTracker {
    private static final Logger LOG = LoggerFactory.getLogger(AcConfigChangeTracker.class);

    public boolean configIsUnchangedComparedToLastExecution(Map<String, String> configFiles, String[] restrictedToPaths, Session session) {
        String executionKey = this.createExecutionKey(configFiles, restrictedToPaths, session);
        try {
            String hashOfConfigFilesThisExecution = this.createHashOverConfigFiles(configFiles);
            if (session.itemExists("/var/statistics/achistory")) {
                String hashValueLastExecution;
                Node acHistoryNode = session.getNode("/var/statistics/achistory");
                String string = hashValueLastExecution = acHistoryNode.hasProperty(executionKey) ? acHistoryNode.getProperty(executionKey).getString() : null;
                if (StringUtils.equals((CharSequence)hashOfConfigFilesThisExecution, (CharSequence)hashValueLastExecution)) {
                    LOG.info("Execution key {} with hash {} is equal", (Object)executionKey, (Object)hashOfConfigFilesThisExecution);
                    return true;
                }
                acHistoryNode.setProperty(executionKey, hashOfConfigFilesThisExecution);
                session.save();
            } else {
                LOG.debug("Node {} does not exist yet", (Object)"/var/statistics/achistory");
            }
        }
        catch (Exception e) {
            LOG.info("Could not retrieve/save execution hash of config files: e=" + e, (Throwable)e);
        }
        return false;
    }

    private String createExecutionKey(Map<String, String> configFiles, String[] restrictedToPaths, Session session) {
        boolean isCompositeNodeStore = RuntimeHelper.isCompositeNodeStore(session);
        String restrictedToPathsKey = restrictedToPaths == null || restrictedToPaths.length == 0 ? "ALL_PATHS" : StringUtils.join((Object[])restrictedToPaths, (String)"+").replace("$", "").replace("^", "");
        String effectiveRootPathOfConfigs = AcConfigChangeTracker.getEffectiveConfigRootPath(configFiles);
        String executionKey = "hash(" + StringUtils.removeEnd((String)effectiveRootPathOfConfigs, (String)"/").replace('/', '\\') + "," + restrictedToPathsKey.replace('/', '\\').replace(':', '_') + "," + (isCompositeNodeStore ? "compNodeStore" : "stdRepo") + ")";
        return executionKey;
    }

    static String getEffectiveConfigRootPath(Map<String, String> configFiles) {
        return StringUtils.getCommonPrefix((String[])configFiles.keySet().toArray(new String[configFiles.size()]));
    }

    private String createHashOverConfigFiles(Map<String, String> configFiles) throws Exception {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, String> test : configFiles.entrySet()) {
            buf.append(test.getKey() + "\n" + test.getValue());
        }
        return this.md5(buf.toString());
    }

    private String md5(String input) throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] hashInBytes = md.digest(input.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte b : hashInBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

