/*
 * Decompiled with CFR 0.152.
 */
package biz.netcentric.cq.tools.actool.aem;

import biz.netcentric.cq.tools.actool.crypto.DecryptionService;
import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.ranking:Integer=1000"})
public class AemCryptoDecryptionService
implements DecryptionService {
    private static final Logger LOG = LoggerFactory.getLogger(AemCryptoDecryptionService.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private CryptoSupport cryptoSupport;

    @Override
    public String decrypt(String text) {
        if (!this.cryptoSupport.isProtected(text)) {
            LOG.debug("Given text is not encrypted and therefore doesn't need decryption: {}", (Object)text);
            return text;
        }
        String abbreviatedPasswordHint = text.substring(0, 4) + "..";
        try {
            String unprotected = this.cryptoSupport.unprotect(text);
            LOG.debug("Decrypted {} to text with {} chars", (Object)abbreviatedPasswordHint, (Object)unprotected.length());
            return unprotected;
        }
        catch (CryptoException e) {
            throw new IllegalArgumentException("Invalid password string starting with '" + abbreviatedPasswordHint + "' (cannot be decrypted)", e);
        }
    }
}

