/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugins.lesscss.compiler;

import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceImportsCache;
import biz.gabrys.lesscss.extended.compiler.cache.SourceModificationDateCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationCheckerImpl;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.control.expiration.SourceModificationDateBasedExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import java.util.Date;
import org.apache.maven.plugin.logging.Log;

public class PluginSourceExpirationChecker
implements CompiledSourceExpirationChecker {
    private final CompiledSourceExpirationChecker expirationChecker;
    private final Log logger;

    public PluginSourceExpirationChecker(FullCache cache, SourceFactory sourceFactory, Log logger) {
        this.expirationChecker = new CompiledSourceExpirationCheckerWithLogger(cache, sourceFactory, logger);
        this.logger = logger;
    }

    public boolean isExpired(LessSource source, Date compilationDate) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((CharSequence)"Verificating whether the source file or at least one import need compilation...");
        }
        boolean expired = this.expirationChecker.isExpired(source, compilationDate);
        if (this.logger.isDebugEnabled() && !expired) {
            this.logger.debug((CharSequence)"Cache for the source file and all imports are up to date");
        }
        return expired;
    }

    private static final class SourceExpirationCheckerWithLogger
    implements SourceExpirationChecker {
        private final SourceExpirationChecker expirationChecker;
        private final Log logger;

        private SourceExpirationCheckerWithLogger(SourceModificationDateCache cache, Log logger) {
            this.expirationChecker = new SourceModificationDateBasedExpirationChecker(cache);
            this.logger = logger;
        }

        public boolean isExpired(LessSource source) {
            boolean expired = this.expirationChecker.isExpired(source);
            if (this.logger.isDebugEnabled() && expired) {
                this.logger.debug((CharSequence)String.format("Cache for source file %s expired, file need compilation", source.getPath()));
            }
            return expired;
        }
    }

    private static final class CompiledSourceExpirationCheckerWithLogger
    extends CompiledSourceExpirationCheckerImpl {
        private final Log logger;

        private CompiledSourceExpirationCheckerWithLogger(FullCache cache, SourceFactory sourceFactory, Log logger) {
            super((SourceExpirationChecker)new SourceExpirationCheckerWithLogger((SourceModificationDateCache)cache, logger), (SourceModificationDateCache)cache, (SourceImportsCache)cache, sourceFactory);
            this.logger = logger;
        }

        protected boolean isModifiedAfterLastCompilation(LessSource source, Date lastCompilationDate) {
            boolean expired = super.isModifiedAfterLastCompilation(source, lastCompilationDate);
            if (this.logger.isDebugEnabled() && expired) {
                this.logger.debug((CharSequence)String.format("Cache for source in older than import %s, file need compilation", source.getPath()));
            }
            return expired;
        }
    }
}

