/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugins.lesscss.compiler;

import biz.gabrys.lesscss.compiler.CompilerException;
import biz.gabrys.lesscss.compiler.CompilerOptions;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompilerException;
import biz.gabrys.lesscss.extended.compiler.cache.CompilationDateCache;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import java.util.Date;
import org.apache.maven.plugin.MojoFailureException;

public class PluginCompiler {
    private final ExtendedCompiler compiler;
    private final CompilationDateCache cache;
    private Date compilationDate;

    public PluginCompiler(ExtendedCompiler compiler, CompilationDateCache cache) {
        this.cache = cache;
        this.compiler = compiler;
    }

    public String compile(LessSource source, CompilerOptions options) throws MojoFailureException {
        String compiledCode;
        this.compilationDate = new Date();
        try {
            compiledCode = this.compiler.compile(source, options);
        }
        catch (ExtendedCompilerException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        catch (CompilerException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
        if (this.cache != null && this.cache.hasCompilationDate(source)) {
            this.compilationDate = this.cache.getCompilationDate(source);
        }
        return compiledCode;
    }

    public Date getCompilationDate() {
        return (Date)this.compilationDate.clone();
    }
}

