/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugins.lesscss.compiler;

import biz.gabrys.lesscss.extended.compiler.cache.SourceCodeCache;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import java.io.File;

public class PathInCommentSourceCodeCache
implements SourceCodeCache {
    public static final String START_CLASS_PREFIX = "start-";
    public static final String END_CLASS_PREFIX = "end-";
    private final SourceCodeCache cache;
    private final String className;

    public PathInCommentSourceCodeCache(SourceCodeCache cache, String className) {
        this.cache = cache;
        this.className = className;
    }

    public void saveSourceCode(LessSource source, String sourceCode) {
        StringBuilder newSourceCode = new StringBuilder();
        newSourceCode.append(this.createClass(source, true));
        newSourceCode.append(sourceCode);
        newSourceCode.append(this.createClass(source, false));
        this.cache.saveSourceCode(source, newSourceCode.toString());
    }

    private CharSequence createClass(LessSource source, boolean start) {
        StringBuilder css = new StringBuilder(100);
        if (!start) {
            css.append('\n');
        }
        css.append('.');
        css.append(this.className);
        css.append('-');
        css.append(System.currentTimeMillis());
        css.append("{name:\"");
        css.append(start ? START_CLASS_PREFIX : END_CLASS_PREFIX);
        css.append(source.getPath());
        css.append("\";}");
        if (start) {
            css.append('\n');
        }
        return css;
    }

    public boolean hasSourceCode(LessSource source) {
        return this.cache.hasSourceCode(source);
    }

    public File getSourceFile(LessSource source) {
        return this.cache.getSourceFile(source);
    }

    public String getSourceRelativePath(LessSource source) {
        return this.cache.getSourceRelativePath(source);
    }
}

