/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugins.lesscss.compiler;

import biz.gabrys.lesscss.extended.compiler.control.processor.PostCompilationProcessor;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import java.util.regex.Pattern;

public class PathInCommentPostProcessor
implements PostCompilationProcessor {
    private final String classPattern;

    public PathInCommentPostProcessor(String className) {
        StringBuilder pattern = new StringBuilder(100);
        pattern.append("\\.");
        pattern.append(Pattern.quote(className));
        pattern.append("-(\\d)+(\\s)*\\{(\\s)*name:(\\s)*\"");
        this.classPattern = pattern.toString();
    }

    public String prepare(LessSource source, String compiledCode) {
        String[] parts = compiledCode.split(this.classPattern);
        if (parts.length == 1) {
            return parts[0];
        }
        StringBuilder processedCode = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            StringBuilder comment = new StringBuilder();
            if (part.startsWith("start-")) {
                comment.append("/* Start ");
                part = part.substring("start-".length());
            } else {
                comment.append("/* End ");
                part = part.substring("end-".length());
            }
            int index = part.indexOf(34);
            comment.append(part.substring(0, index));
            comment.append(" */");
            processedCode.append((CharSequence)comment);
            index = part.indexOf(125);
            processedCode.append(part.substring(index + 1));
        }
        return processedCode.toString();
    }
}

