/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugins.lesscss.compiler;

import biz.gabrys.lesscss.extended.compiler.cache.CompilationDateCache;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import java.util.Date;
import org.apache.maven.plugin.logging.Log;

public class LoggingCompilationDateCache
implements CompilationDateCache {
    private final CompilationDateCache cache;
    private final Log logger;

    public LoggingCompilationDateCache(CompilationDateCache cache, Log logger) {
        this.cache = cache;
        this.logger = logger;
    }

    public void saveCompilationDate(LessSource source, Date compilationDate) {
        this.cache.saveCompilationDate(source, compilationDate);
    }

    public boolean hasCompilationDate(LessSource source) {
        boolean dateAvailable = this.cache.hasCompilationDate(source);
        if (!dateAvailable) {
            this.logger.debug((CharSequence)"The source file has not been compiled before, file need compilation");
        }
        return dateAvailable;
    }

    public Date getCompilationDate(LessSource source) {
        return this.cache.getCompilationDate(source);
    }
}

