/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugins.lesscss;

import biz.gabrys.lesscss.compiler.CompilerOptions;
import biz.gabrys.lesscss.compiler.CompilerOptionsBuilder;
import biz.gabrys.lesscss.extended.compiler.CachingCompiledCodeExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.CachingSourceCodeExtendedCompilerBuilder;
import biz.gabrys.lesscss.extended.compiler.ExtendedCompiler;
import biz.gabrys.lesscss.extended.compiler.NonCachingExtendedCompilerBuilder;
import biz.gabrys.lesscss.extended.compiler.cache.CompilationDateCache;
import biz.gabrys.lesscss.extended.compiler.cache.CompiledCodeCache;
import biz.gabrys.lesscss.extended.compiler.cache.FullCache;
import biz.gabrys.lesscss.extended.compiler.cache.FullCacheAdapterBuilder;
import biz.gabrys.lesscss.extended.compiler.cache.FullCacheBuilder;
import biz.gabrys.lesscss.extended.compiler.cache.FullCacheImpl;
import biz.gabrys.lesscss.extended.compiler.cache.SourceCodeCache;
import biz.gabrys.lesscss.extended.compiler.control.expiration.CompiledSourceExpirationChecker;
import biz.gabrys.lesscss.extended.compiler.source.LessSource;
import biz.gabrys.lesscss.extended.compiler.source.LocalSource;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactory;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryBuilder;
import biz.gabrys.lesscss.extended.compiler.source.SourceFactoryImpl;
import biz.gabrys.maven.plugin.util.classpath.ContextClassLoaderExtender;
import biz.gabrys.maven.plugin.util.io.DestinationFileCreator;
import biz.gabrys.maven.plugin.util.io.FileScanner;
import biz.gabrys.maven.plugin.util.io.ScannerFactory;
import biz.gabrys.maven.plugin.util.io.ScannerPatternFormat;
import biz.gabrys.maven.plugin.util.parameter.ParametersLogBuilder;
import biz.gabrys.maven.plugin.util.parameter.converter.ValueToStringConverter;
import biz.gabrys.maven.plugin.util.parameter.sanitizer.LazySimpleSanitizer;
import biz.gabrys.maven.plugin.util.parameter.sanitizer.SimpleSanitizer;
import biz.gabrys.maven.plugin.util.parameter.sanitizer.ValueSanitizer;
import biz.gabrys.maven.plugin.util.timer.SystemTimer;
import biz.gabrys.maven.plugin.util.timer.Time;
import biz.gabrys.maven.plugins.lesscss.compiler.LoggingCompilationDateCache;
import biz.gabrys.maven.plugins.lesscss.compiler.LoggingCompiledCodeCache;
import biz.gabrys.maven.plugins.lesscss.compiler.LoggingCompiler;
import biz.gabrys.maven.plugins.lesscss.compiler.PathInCommentPostProcessor;
import biz.gabrys.maven.plugins.lesscss.compiler.PathInCommentSourceCodeCache;
import biz.gabrys.maven.plugins.lesscss.compiler.PluginCompiler;
import biz.gabrys.maven.plugins.lesscss.compiler.PluginSourceExpirationChecker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="compile", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, threadSafe=true)
public class CompileMojo
extends AbstractMojo {
    @Parameter(property="lesscss.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="lesscss.verbose", defaultValue="false")
    protected boolean verbose;
    @Parameter(property="lesscss.force", defaultValue="false")
    protected boolean force;
    @Parameter(property="lesscss.alwaysOverwrite", defaultValue="false")
    protected boolean alwaysOverwrite;
    @Parameter(property="lesscss.sourceDirectory", defaultValue="${project.basedir}/src/main/less")
    protected File sourceDirectory;
    @Parameter(property="lesscss.outputDirectory", defaultValue="${project.build.directory}")
    protected File outputDirectory;
    @Parameter(property="lesscss.filesetPatternFormat", defaultValue="ant")
    protected String filesetPatternFormat;
    @Parameter
    protected String[] includes = new String[0];
    @Parameter
    protected String[] excludes = new String[0];
    @Parameter(property="lesscss.compilerType", defaultValue="full")
    protected String compilerType;
    @Parameter(property="lesscss.classpathLoadedDependenciesTypes")
    protected String[] classpathLoadedDependenciesTypes = new String[0];
    @Parameter(property="lesscss.addCommentsWithPaths", defaultValue="false")
    protected boolean addCommentsWithPaths;
    @Parameter(property="lesscss.addCommentsWithPathsClassPrefix", defaultValue="gabrys-biz-comment-with-path-marker-class")
    protected String addCommentsWithPathsClassPrefix;
    @Parameter(property="lesscss.compress", defaultValue="false")
    protected boolean compress;
    @Parameter
    protected String[] compilerOptions = new String[0];
    @Parameter(property="lesscss.encoding", defaultValue="${project.build.sourceEncoding}")
    protected String encoding;
    @Parameter(property="lesscss.outputFileFormat", defaultValue="{fileName}.css")
    protected String outputFileFormat;
    @Parameter(property="lesscss.watch", defaultValue="false")
    protected boolean watch;
    @Parameter(property="lesscss.watchInterval", defaultValue="5")
    protected int watchInterval;
    @Parameter(property="lesscss.workingDirectory", defaultValue="${project.build.directory}/gabrys-biz-lesscss-maven-plugin")
    protected File workingDirectory;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;

    private void logParameters() {
        if (!this.getLog().isDebugEnabled()) {
            return;
        }
        ParametersLogBuilder logger = new ParametersLogBuilder(this.getLog());
        logger.append("skip", (Object)this.skip);
        logger.append("verbose", (Object)this.verbose, (ValueSanitizer)new SimpleSanitizer(this.verbose, (Object)Boolean.TRUE));
        logger.append("force", (Object)this.force, (ValueSanitizer)new SimpleSanitizer(!this.watch || !this.force, (Object)Boolean.FALSE));
        logger.append("alwaysOverwrite", (Object)this.alwaysOverwrite, (ValueSanitizer)new SimpleSanitizer(this.watch || !this.force || this.alwaysOverwrite, (Object)Boolean.TRUE));
        logger.append("sourceDirectory", (Object)this.sourceDirectory);
        logger.append("outputDirectory", (Object)this.outputDirectory);
        logger.append("filesetPatternFormat", (Object)this.filesetPatternFormat);
        logger.append("includes", (Object)this.includes, (ValueSanitizer)new LazySimpleSanitizer(this.includes.length != 0, new LazySimpleSanitizer.ValueContainer(){

            public Object getValue() {
                return CompileMojo.this.getDefaultIncludes();
            }
        }));
        logger.append("excludes", (Object)this.excludes);
        logger.append("compilerType", (Object)this.compilerType);
        logger.append("classpathLoadedDependenciesTypes", (Object)this.classpathLoadedDependenciesTypes, (ValueSanitizer)new LazySimpleSanitizer(this.classpathLoadedDependenciesTypes.length != 0, new LazySimpleSanitizer.ValueContainer(){

            public Object getValue() {
                return CompileMojo.getDefaultClasspathLoadedDependenciesTypes();
            }
        }));
        logger.append("addCommentsWithPaths", (Object)this.addCommentsWithPaths, (ValueSanitizer)new SimpleSanitizer(!this.compress, (Object)Boolean.FALSE));
        logger.append("addCommentsWithPathsClassPrefix", (Object)this.addCommentsWithPathsClassPrefix);
        logger.append("compress", (Object)this.compress);
        logger.append("compilerOptions", (Object)this.compilerOptions);
        logger.append("encoding", (Object)this.encoding);
        logger.append("outputFileFormat", (Object)this.outputFileFormat);
        logger.append("watch", (Object)this.watch);
        logger.append("watchInterval", (Object)this.watchInterval, new ValueToStringConverter(){
            private static final long MILLISECONDS_IN_SECOND = 1000L;

            public String convert(Object value) {
                Integer number = (Integer)value;
                StringBuilder text = new StringBuilder();
                text.append(number);
                if (number > 0) {
                    text.append(" (");
                    text.append(new Time((long)number.intValue() * 1000L));
                    text.append(')');
                }
                return text.toString();
            }
        }, (ValueSanitizer)new SimpleSanitizer(this.watchInterval > 0, (Object)1));
        logger.append("workingDirectory", (Object)this.workingDirectory);
        logger.debug();
    }

    private String[] getDefaultIncludes() {
        if (ScannerPatternFormat.ANT.name().equalsIgnoreCase(this.filesetPatternFormat)) {
            return new String[]{"**/*.less"};
        }
        return new String[]{"^.+\\.less$"};
    }

    private static String[] getDefaultClasspathLoadedDependenciesTypes() {
        return new String[]{"jar", "war", "zip"};
    }

    private void calculateParameters() {
        if (this.getLog().isDebugEnabled()) {
            this.verbose = true;
        }
        if (this.watch) {
            this.force = false;
        }
        if (this.force) {
            this.alwaysOverwrite = true;
        }
        if (this.compress) {
            this.addCommentsWithPaths = false;
        }
        if (this.includes.length == 0) {
            this.includes = this.getDefaultIncludes();
        }
        if (this.classpathLoadedDependenciesTypes.length == 0) {
            this.classpathLoadedDependenciesTypes = CompileMojo.getDefaultClasspathLoadedDependenciesTypes();
        }
        if (this.watchInterval < 1) {
            this.watchInterval = 1;
        }
    }

    public void execute() throws MojoFailureException {
        this.logParameters();
        if (this.skip) {
            this.getLog().info((CharSequence)"Skips job execution");
            return;
        }
        this.calculateParameters();
        if ("full".equals(this.compilerType)) {
            this.addDependenciesToClasspath();
        }
        if (this.watch) {
            this.runWatchMode();
        } else {
            this.runCompilation();
        }
    }

    private void addDependenciesToClasspath() {
        if (this.verbose) {
            this.getLog().info((CharSequence)"Adding project dependencies to classpath...");
        }
        ContextClassLoaderExtender extender = new ContextClassLoaderExtender(this.project, this.getLog());
        extender.addDependencies(this.classpathLoadedDependenciesTypes);
    }

    private void runWatchMode() throws MojoFailureException {
        this.getLog().info((CharSequence)("Starts watch mode on the " + this.sourceDirectory));
        Thread.currentThread().setPriority(1);
        long interval = (long)this.watchInterval * 1000L;
        while (true) {
            this.runCompilation();
            try {
                Thread.sleep(interval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    private void runCompilation() throws MojoFailureException {
        if (!this.sourceDirectory.exists()) {
            this.getLog().warn((CharSequence)("Source directory does not exist: " + this.sourceDirectory.getAbsolutePath()));
            return;
        }
        Collection<File> files = this.getFiles();
        if (files.isEmpty()) {
            this.getLog().warn((CharSequence)"No sources to compile");
            return;
        }
        if (this.force) {
            this.deleteWorkingDirectory();
        }
        this.compileFiles(files);
    }

    private Collection<File> getFiles() {
        ScannerPatternFormat patternFormat = ScannerPatternFormat.toPattern((String)this.filesetPatternFormat);
        FileScanner scanner = new ScannerFactory().create(patternFormat, this.getLog());
        if (this.verbose) {
            this.getLog().info((CharSequence)"Scanning directory for sources...");
        }
        return scanner.getFiles(this.sourceDirectory, this.includes, this.excludes);
    }

    private void deleteWorkingDirectory() throws MojoFailureException {
        if (!this.workingDirectory.exists()) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Deleting working directory: " + this.workingDirectory.getAbsolutePath()));
        }
        try {
            FileUtils.deleteDirectory((File)this.workingDirectory);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Cannot delete working directory: %s", this.workingDirectory.getAbsolutePath()), (Throwable)e);
        }
    }

    private void compileFiles(Collection<File> files) throws MojoFailureException {
        PluginCompiler compiler = this.createCompiler();
        CompilerOptions options = this.createOptions();
        String sourceFilesText = "source" + (files.size() != 1 ? "s" : "");
        this.getLog().info((CharSequence)String.format("Compiling %s %s to %s", files.size(), sourceFilesText, this.outputDirectory.getAbsolutePath()));
        SystemTimer timer = SystemTimer.getStartedTimer();
        for (File file : files) {
            this.compileFile(compiler, options, file);
        }
        this.getLog().info((CharSequence)String.format("Finished %s compilation in %s", sourceFilesText, timer.stop()));
    }

    private PluginCompiler createCompiler() {
        ExtendedCompiler compiler;
        SourceFactoryImpl sourceFactory;
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)"Creating compiler...");
        }
        FullCacheImpl cache = null;
        if ("full".equalsIgnoreCase(this.compilerType)) {
            cache = new FullCacheBuilder().withDirectory(this.workingDirectory).create();
            sourceFactory = new SourceFactoryBuilder().withClasspath().withStandard().create();
            PathInCommentPostProcessor postProcessor = null;
            if (this.addCommentsWithPaths) {
                cache = new FullCacheAdapterBuilder((FullCache)cache).withSourceCodeCache((SourceCodeCache)new PathInCommentSourceCodeCache((SourceCodeCache)cache, this.addCommentsWithPathsClassPrefix)).create();
                postProcessor = new PathInCommentPostProcessor(this.addCommentsWithPathsClassPrefix);
            }
            compiler = new CachingSourceCodeExtendedCompilerBuilder((FullCache)cache).withSourceFactory((SourceFactory)sourceFactory).withPostProcessor(postProcessor).create();
        } else if ("local".equalsIgnoreCase(this.compilerType)) {
            sourceFactory = this.force ? null : new SourceFactoryBuilder().withLocal().create();
            compiler = new NonCachingExtendedCompilerBuilder().create();
        } else {
            throw new IllegalArgumentException(String.format("Cannot find compiler for type \"%s\"", this.compilerType));
        }
        if (this.verbose) {
            compiler = new LoggingCompiler(compiler, this.getLog());
        }
        if (!this.force) {
            FullCacheImpl fullCacheImpl = cache = cache != null ? cache : new FullCacheBuilder().withDirectory(this.workingDirectory).create();
            if (this.verbose) {
                FullCacheAdapterBuilder builder = new FullCacheAdapterBuilder((FullCache)cache);
                builder.withCompiledCodeCache((CompiledCodeCache)new LoggingCompiledCodeCache((CompiledCodeCache)cache, this.getLog()));
                if (this.getLog().isDebugEnabled()) {
                    builder.withCompilationDateCache((CompilationDateCache)new LoggingCompilationDateCache((CompilationDateCache)cache, this.getLog()));
                }
                cache = builder.create();
            }
            PluginSourceExpirationChecker expirationChecker = new PluginSourceExpirationChecker((FullCache)cache, (SourceFactory)sourceFactory, this.getLog());
            compiler = new CachingCompiledCodeExtendedCompiler(compiler, (CompiledSourceExpirationChecker)expirationChecker, (CompilationDateCache)cache, (CompiledCodeCache)cache);
        }
        return new PluginCompiler(compiler, (CompilationDateCache)cache);
    }

    private CompilerOptions createOptions() {
        CompilerOptionsBuilder builder = new CompilerOptionsBuilder();
        builder.setMinified(this.compress);
        CompilerOptions options = builder.create();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(options.getArguments());
        arguments.addAll(Arrays.asList(this.compilerOptions));
        return new CompilerOptions(arguments);
    }

    private void compileFile(PluginCompiler compiler, CompilerOptions options, File source) throws MojoFailureException {
        SystemTimer timer = null;
        if (this.verbose) {
            this.getLog().info((CharSequence)("Processing Less source: " + source.getAbsolutePath()));
            timer = SystemTimer.getStartedTimer();
        }
        String compiled = compiler.compile((LessSource)new LocalSource(source, this.encoding), options);
        this.saveCompiledCode(source, compiled, compiler.getCompilationDate());
        if (timer != null) {
            this.getLog().info((CharSequence)("Finished in " + timer.stop()));
        }
    }

    private void saveCompiledCode(File source, String compiled, Date compilationDate) throws MojoFailureException {
        boolean skipsFileSaving;
        File destination = new DestinationFileCreator(this.sourceDirectory, this.outputDirectory, this.outputFileFormat).create(source);
        boolean bl = skipsFileSaving = !this.force && !this.alwaysOverwrite && destination.exists() && compilationDate.before(new Date(destination.lastModified()));
        if (skipsFileSaving) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("Skips saving CSS compiled code to file, because cached version is older than destination file: " + destination.getAbsolutePath()));
            }
            return;
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)("Saving CSS code to " + destination.getAbsolutePath()));
        }
        try {
            FileUtils.write((File)destination, (CharSequence)compiled, (String)this.encoding);
        }
        catch (IOException e) {
            throw new MojoFailureException(String.format("Cannot save CSS compiled code to file: %s", destination.getAbsolutePath()), (Throwable)e);
        }
    }
}

