/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.timer;

public class Time {
    private static final int MILLISECONDS_IN_SECOND = 1000;
    private static final int SECONDS_IN_MINUTE = 60;
    private static final int MINUTES_IN_HOUR = 60;
    private final long milliseconds;

    public Time(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public long toMilliseconds() {
        return this.milliseconds;
    }

    public int hashCode() {
        return (int)(this.milliseconds ^ this.milliseconds >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Time other = (Time)obj;
        return this.milliseconds == other.milliseconds;
    }

    public String toString() {
        String text;
        long hours;
        long millis = this.milliseconds % 1000L;
        long seconds = this.milliseconds / 1000L;
        long minutes = seconds / 60L;
        if (minutes > 0L) {
            seconds -= minutes * 60L;
        }
        if ((hours = minutes / 60L) > 0L) {
            minutes -= hours * 60L;
        }
        StringBuilder time = new StringBuilder();
        if (hours > 0L) {
            Time.appendTimeWithUnit(time, hours, "hour");
        }
        if (minutes > 0L) {
            Time.appendTimeWithUnit(time, minutes, "minute");
        }
        if (seconds > 0L) {
            Time.appendTimeWithUnit(time, seconds, "second");
        }
        if (millis > 0L) {
            Time.appendTimeWithUnit(time, millis, "millisecond");
        }
        if ((text = time.toString()).length() == 0) {
            return Time.createText(0L, "second");
        }
        return text;
    }

    private static void appendTimeWithUnit(StringBuilder text, long time, String unit) {
        if (text.length() > 0) {
            text.append(' ');
        }
        text.append(Time.createText(time, unit));
    }

    private static String createText(long value, String unit) {
        StringBuilder text = new StringBuilder();
        text.append(value);
        text.append(' ');
        text.append(unit);
        if (value != 1L) {
            text.append('s');
        }
        return text.toString();
    }
}

