/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.parameter.converter;

import biz.gabrys.maven.plugin.util.parameter.converter.AbstractValueToStringConverter;
import biz.gabrys.maven.plugin.util.parameter.converter.ArrayToStringConverter;
import biz.gabrys.maven.plugin.util.parameter.converter.CollectionToStringConverter;
import biz.gabrys.maven.plugin.util.parameter.converter.ObjectToStringConverter;
import biz.gabrys.maven.plugin.util.parameter.converter.ValueToStringConverter;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValueToStringConverter
extends AbstractValueToStringConverter {
    private final Map<Class<?>, ValueToStringConverter> converters;
    private final ValueToStringConverter fallback;

    public DefaultValueToStringConverter() {
        this.converters = new ConcurrentHashMap();
        this.converters.put(Object[].class, new ArrayToStringConverter());
        this.converters.put(Collection.class, new CollectionToStringConverter());
        this.fallback = new ObjectToStringConverter();
    }

    DefaultValueToStringConverter(Map<Class<?>, ValueToStringConverter> converters, ValueToStringConverter fallback) {
        this.converters = converters;
        this.fallback = fallback;
    }

    @Override
    public String convert2(Object value) {
        for (Map.Entry<Class<?>, ValueToStringConverter> entry : this.converters.entrySet()) {
            if (!entry.getKey().isInstance(value)) continue;
            return entry.getValue().convert(value);
        }
        return this.fallback.convert(value);
    }
}

