/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.parameter;

import biz.gabrys.maven.plugin.util.parameter.ParameterUtils;
import biz.gabrys.maven.plugin.util.parameter.converter.DefaultValueToStringConverter;
import biz.gabrys.maven.plugin.util.parameter.converter.ValueToStringConverter;
import biz.gabrys.maven.plugin.util.parameter.sanitizer.AlwaysValidSanitizer;
import biz.gabrys.maven.plugin.util.parameter.sanitizer.ValueSanitizer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersLogBuilder {
    protected final Map<String, Container> parameters;
    protected final Log logger;

    public ParametersLogBuilder(Log logger) {
        this(new LinkedHashMap<String, Container>(), logger);
    }

    protected ParametersLogBuilder(Map<String, Container> parameters, Log logger) {
        ParameterUtils.verifyNotNull("parameters", parameters);
        ParameterUtils.verifyNotNull("logger", logger);
        this.parameters = parameters;
        this.logger = logger;
    }

    public ParametersLogBuilder append(String name, Object value) {
        return this.append(name, value, new DefaultValueToStringConverter(), new AlwaysValidSanitizer());
    }

    public ParametersLogBuilder append(String name, Object value, ValueToStringConverter converter) {
        return this.append(name, value, converter, new AlwaysValidSanitizer());
    }

    public ParametersLogBuilder append(String name, Object value, ValueSanitizer sanitizer) {
        return this.append(name, value, new DefaultValueToStringConverter(), sanitizer);
    }

    public ParametersLogBuilder append(String name, Object value, ValueToStringConverter converter, ValueSanitizer sanitizer) {
        this.parameters.remove(name);
        this.parameters.put(name, new Container(value, converter, sanitizer));
        return this;
    }

    public boolean info() {
        return this.log(new InfoInternalLoggerAdapter(this.logger));
    }

    public boolean debug() {
        return this.log(new DebugInternalLoggerAdapter(this.logger));
    }

    protected boolean log(InternalLogger internalLogger) {
        if (!internalLogger.isEnabled()) {
            return false;
        }
        List<String> lines = this.createLines();
        if (lines.isEmpty()) {
            return false;
        }
        for (String line : lines) {
            internalLogger.log(line);
        }
        return true;
    }

    protected List<String> createLines() {
        ArrayList<String> lines = new ArrayList<String>(this.parameters.size() + 2);
        lines.add("Job parameters:");
        lines.addAll(this.createParametersLines());
        lines.add("");
        return lines;
    }

    protected List<String> createParametersLines() {
        ArrayList<String> lines = new ArrayList<String>(this.parameters.size());
        for (Map.Entry<String, Container> entry : this.parameters.entrySet()) {
            lines.add(this.createParemeterLine(entry.getKey(), entry.getValue()));
        }
        return lines;
    }

    protected String createParemeterLine(String name, Container container) {
        StringBuilder line = new StringBuilder();
        line.append("      ");
        line.append(name);
        line.append(" = ");
        line.append(this.createParameterValue(container));
        return line.toString();
    }

    protected String createParameterValue(Container container) {
        StringBuilder line = new StringBuilder();
        ValueToStringConverter converter = container.getConverter();
        Object value = container.getValue();
        line.append(converter.convert(value));
        ValueSanitizer sanitizer = container.getSanitizer();
        if (!sanitizer.isValid(value)) {
            line.append(" (calculated: ");
            Object correctedValue = sanitizer.sanitize(value);
            line.append(converter.convert(correctedValue));
            line.append(')');
        }
        return line.toString();
    }

    protected static class DebugInternalLoggerAdapter
    implements InternalLogger {
        private final Log logger;

        protected DebugInternalLoggerAdapter(Log logger) {
            this.logger = logger;
        }

        public boolean isEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void log(CharSequence line) {
            this.logger.debug(line);
        }
    }

    protected static class InfoInternalLoggerAdapter
    implements InternalLogger {
        private final Log logger;

        protected InfoInternalLoggerAdapter(Log logger) {
            this.logger = logger;
        }

        public boolean isEnabled() {
            return this.logger.isInfoEnabled();
        }

        public void log(CharSequence line) {
            this.logger.info(line);
        }
    }

    protected static interface InternalLogger {
        public boolean isEnabled();

        public void log(CharSequence var1);
    }

    protected static class Container {
        private final Object value;
        private final ValueToStringConverter converter;
        private final ValueSanitizer sanitizer;

        protected Container(Object value, ValueToStringConverter converter, ValueSanitizer sanitizer) {
            this.value = value;
            this.converter = converter;
            this.sanitizer = sanitizer;
        }

        protected Object getValue() {
            return this.value;
        }

        protected ValueToStringConverter getConverter() {
            return this.converter;
        }

        protected ValueSanitizer getSanitizer() {
            return this.sanitizer;
        }
    }
}

