/*
 * Decompiled with CFR 0.152.
 */
package biz.gabrys.maven.plugin.util.io;

import biz.gabrys.maven.plugin.util.io.FileScanner;
import biz.gabrys.maven.plugin.util.io.LoggingFileFilter;
import biz.gabrys.maven.plugin.util.io.RegexFileFilter;
import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.maven.plugin.logging.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexFileScanner
implements FileScanner {
    private final Log logger;

    public RegexFileScanner() {
        this(null);
    }

    public RegexFileScanner(Log logger) {
        this.logger = logger;
    }

    @Override
    public Collection<File> getFiles(File directory, String[] includes, String[] excludes) {
        IOFileFilter filter = this.createFileFilter(directory, includes, excludes);
        return FileUtils.listFiles((File)directory, (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.INSTANCE);
    }

    protected IOFileFilter createFileFilter(File directory, String[] includes, String[] excludes) {
        Object filter = new RegexFileFilter(directory, includes, excludes);
        if (this.logger != null && this.logger.isDebugEnabled()) {
            filter = new LoggingFileFilter((IOFileFilter)filter, this.logger);
        }
        return filter;
    }
}

